/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Collection;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityHobbitFarmer;
import lotr.common.entity.npc.LOTREntityHobbitFarmhand;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure.LOTRWorldGenHobbitHole;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTRWorldGenHobbitFarm
extends LOTRWorldGenStructureBase2 {
    private Block wood1Block;
    private int wood1Meta;
    private Block wood1SlabBlock;
    private int wood1SlabMeta;
    private Block wood1Stair;
    private Block wood2Block;
    private int wood2Meta;
    private Block cropBlock;
    private Item seedItem;

    public LOTRWorldGenHobbitFarm(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int j1;
        int i1;
        int k1;
        int j12;
        int k12;
        int i12;
        int k13;
        int i13;
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        --j;
        this.setRotationMode(rotation);
        switch (this.getRotationMode()) {
            case 0: {
                k += 6;
                break;
            }
            case 1: {
                i -= 6;
                break;
            }
            case 2: {
                k -= 6;
                break;
            }
            case 3: {
                i += 6;
            }
        }
        this.setOrigin(i, j, k);
        int randomWood = random.nextInt(4);
        switch (randomWood) {
            case 0: {
                this.wood1Block = Blocks.field_150344_f;
                this.wood1Meta = 0;
                this.wood1SlabBlock = Blocks.field_150376_bx;
                this.wood1SlabMeta = 0;
                this.wood1Stair = Blocks.field_150476_ad;
                break;
            }
            case 1: {
                this.wood1Block = Blocks.field_150344_f;
                this.wood1Meta = 2;
                this.wood1SlabBlock = Blocks.field_150376_bx;
                this.wood1SlabMeta = 2;
                this.wood1Stair = Blocks.field_150487_bG;
                break;
            }
            case 2: {
                this.wood1Block = LOTRMod.planks;
                this.wood1Meta = 0;
                this.wood1SlabBlock = LOTRMod.woodSlabSingle;
                this.wood1SlabMeta = 0;
                this.wood1Stair = LOTRMod.stairsShirePine;
                break;
            }
            case 3: {
                this.wood1Block = LOTRMod.planks;
                this.wood1Meta = 4;
                this.wood1SlabBlock = LOTRMod.woodSlabSingle;
                this.wood1SlabMeta = 4;
                this.wood1Stair = LOTRMod.stairsApple;
            }
        }
        int randomWood2 = random.nextInt(2);
        switch (randomWood2) {
            case 0: {
                this.wood2Block = Blocks.field_150344_f;
                this.wood2Meta = 1;
                break;
            }
            case 1: {
                this.wood2Block = LOTRMod.planks;
                this.wood2Meta = 6;
            }
        }
        int randomCrop = random.nextInt(5);
        switch (randomCrop) {
            case 0: {
                this.cropBlock = Blocks.field_150464_aj;
                this.seedItem = Items.field_151014_N;
                break;
            }
            case 1: {
                this.cropBlock = Blocks.field_150459_bM;
                this.seedItem = Items.field_151172_bF;
                break;
            }
            case 2: {
                this.cropBlock = Blocks.field_150469_bN;
                this.seedItem = Items.field_151174_bG;
                break;
            }
            case 3: {
                this.cropBlock = LOTRMod.lettuceCrop;
                this.seedItem = LOTRMod.lettuce;
                break;
            }
            case 4: {
                this.cropBlock = LOTRMod.pipeweedCrop;
                this.seedItem = LOTRMod.pipeweedSeeds;
            }
        }
        if (this.restrictions) {
            int minHeight = 1;
            int maxHeight = 1;
            for (i13 = -5; i13 <= 10; ++i13) {
                for (k13 = -7; k13 <= 8; ++k13) {
                    int j13 = this.getTopBlock(world, i13, k13);
                    Block block = this.getBlock(world, i13, j13 - 1, k13);
                    if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b) {
                        return false;
                    }
                    if (j13 > maxHeight) {
                        maxHeight = j13;
                    }
                    if (j13 >= minHeight) continue;
                    minHeight = j13;
                }
            }
            if (Math.abs(maxHeight - minHeight) > 6) {
                return false;
            }
        }
        for (i12 = -5; i12 <= 10; ++i12) {
            for (k12 = -7; k12 <= 8; ++k12) {
                for (j12 = 1; j12 <= 10; ++j12) {
                    this.setAir(world, i12, j12, k12);
                }
                this.setBlockAndMetadata(world, i12, 0, k12, (Block)Blocks.field_150349_c, 0);
                this.setGrassToDirt(world, i12, -1, k12);
                j12 = -1;
                while (!this.isOpaque(world, i12, j12, k12) && this.getY(j12) >= 0) {
                    this.setBlockAndMetadata(world, i12, j12, k12, Blocks.field_150346_d, 0);
                    this.setGrassToDirt(world, i12, j12 - 1, k12);
                    --j12;
                }
            }
        }
        for (k1 = -5; k1 <= 6; ++k1) {
            for (i1 = -5; i1 <= 4; ++i1) {
                if (k1 != -5 && k1 != 6 && i1 != -5 && i1 != 4) continue;
                for (j12 = 1; j12 <= 5; ++j12) {
                    this.setBlockAndMetadata(world, i1, j12, k1, this.wood2Block, this.wood2Meta);
                    this.setGrassToDirt(world, i1, j12 - 1, k1);
                }
            }
        }
        for (int stair = 0; stair <= 4; ++stair) {
            int j14 = 5 + stair;
            for (i13 = -5 + stair; i13 <= 4 - stair; ++i13) {
                for (k13 = -5; k13 <= 6; k13 += 11) {
                    this.setBlockAndMetadata(world, i13, j14, k13, this.wood2Block, this.wood2Meta);
                }
            }
            this.setBlockAndMetadata(world, -6 + stair, j14, -6, this.wood1Stair, 1);
            this.setBlockAndMetadata(world, -6 + stair, j14, 7, this.wood1Stair, 1);
            this.setBlockAndMetadata(world, 5 - stair, j14, -6, this.wood1Stair, 0);
            this.setBlockAndMetadata(world, 5 - stair, j14, 7, this.wood1Stair, 0);
            for (int k14 = -5; k14 <= 6; ++k14) {
                this.setBlockAndMetadata(world, -6 + stair, j14, k14, Blocks.field_150390_bg, 1);
                this.setBlockAndMetadata(world, 5 - stair, j14, k14, Blocks.field_150390_bg, 0);
            }
        }
        for (k1 = -4; k1 <= 5; ++k1) {
            for (i1 = -4; i1 <= 3; ++i1) {
                this.setBlockAndMetadata(world, i1, 5, k1, this.wood1Block, this.wood1Meta);
            }
        }
        for (j1 = 1; j1 <= 5; ++j1) {
            for (k12 = -5; k12 <= 6; k12 += 11) {
                this.setBlockAndMetadata(world, -5, j1, k12, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, -2, j1, k12, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, 1, j1, k12, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, 4, j1, k12, this.wood1Block, this.wood1Meta);
            }
            for (i1 = -5; i1 <= 4; i1 += 9) {
                this.setBlockAndMetadata(world, i1, j1, -1, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i1, j1, 2, this.wood1Block, this.wood1Meta);
            }
        }
        for (k1 = 0; k1 <= 1; ++k1) {
            for (i1 = -5; i1 <= 4; i1 += 9) {
                this.setBlockAndMetadata(world, i1, 2, k1, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i1, 4, k1, this.wood1Block, this.wood1Meta);
            }
        }
        for (i12 = -1; i12 <= 0; ++i12) {
            for (k12 = -5; k12 <= 6; k12 += 11) {
                this.setBlockAndMetadata(world, i12, 0, k12, (Block)Blocks.field_150349_c, 0);
                this.setBlockAndMetadata(world, i12, 1, k12, Blocks.field_150396_be, 0);
                this.setAir(world, i12, 2, k12);
                this.setBlockAndMetadata(world, i12, 3, k12, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i12, 5, k12, this.wood1Block, this.wood1Meta);
                this.setBlockAndMetadata(world, i12, 7, k12, Blocks.field_150410_aZ, 0);
            }
            this.setBlockAndMetadata(world, i12, 10, -6, this.wood1SlabBlock, this.wood1SlabMeta);
            this.setBlockAndMetadata(world, i12, 10, 7, this.wood1SlabBlock, this.wood1SlabMeta);
            for (k12 = -5; k12 <= 6; ++k12) {
                this.setBlockAndMetadata(world, i12, 10, k12, (Block)Blocks.field_150333_U, 5);
            }
        }
        for (i12 = -3; i12 <= 2; ++i12) {
            this.setBlockAndMetadata(world, i12, 5, -6, this.wood1Stair, 6);
            this.setBlockAndMetadata(world, i12, 5, 7, this.wood1Stair, 7);
        }
        this.setBlockAndMetadata(world, -5, 5, -6, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -4, 5, -6, this.wood1Stair, 4);
        this.setBlockAndMetadata(world, 3, 5, -6, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 4, 5, -6, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -5, 5, 7, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, -4, 5, 7, this.wood1Stair, 4);
        this.setBlockAndMetadata(world, 3, 5, 7, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 4, 5, 7, this.wood1Block, this.wood1Meta);
        for (i12 = -4; i12 <= 3; i12 += 7) {
            for (k12 = -1; k12 <= 2; k12 += 3) {
                this.setBlockAndMetadata(world, i12, 1, k12, Blocks.field_150462_ai, 0);
                this.setBlockAndMetadata(world, i12, 2, k12, Blocks.field_150422_aJ, 0);
                this.setBlockAndMetadata(world, i12, 3, k12, Blocks.field_150422_aJ, 0);
                this.setBlockAndMetadata(world, i12, 4, k12, Blocks.field_150478_aa, 5);
            }
        }
        this.setBlockAndMetadata(world, -4, 1, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 2, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -3, 1, -4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, -3, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 2, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -3, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, -4, 1, 4, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 2, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 2, 1, 5, Blocks.field_150407_cf, 0);
        this.setBlockAndMetadata(world, 3, 1, 4, Blocks.field_150407_cf, 0);
        for (j1 = 1; j1 <= 4; ++j1) {
            this.setBlockAndMetadata(world, 2, j1, -3, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 1, 1, -4, this.wood1Stair, 1);
        this.setBlockAndMetadata(world, 2, 1, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 2, 2, -4, this.wood1Stair, 1);
        this.setBlockAndMetadata(world, 3, 1, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 3, 2, -4, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 3, 2, -3, this.wood1Stair, 7);
        this.setBlockAndMetadata(world, 3, 3, -3, this.wood1Stair, 2);
        this.setBlockAndMetadata(world, 3, 3, -2, this.wood1Block, this.wood1Meta);
        this.setBlockAndMetadata(world, 2, 3, -2, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 2, 4, -2, this.wood1Stair, 0);
        this.setBlockAndMetadata(world, 1, 4, -2, this.wood1Stair, 5);
        this.setBlockAndMetadata(world, 1, 5, -2, this.wood1Stair, 0);
        this.setAir(world, 3, 5, -4);
        this.setAir(world, 3, 5, -3);
        this.setAir(world, 3, 5, -2);
        this.setAir(world, 2, 5, -2);
        for (i12 = 0; i12 <= 2; ++i12) {
            this.setBlockAndMetadata(world, i12, 6, -3, Blocks.field_150422_aJ, 0);
            this.setBlockAndMetadata(world, i12, 6, -1, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 2, 6, -4, Blocks.field_150422_aJ, 0);
        this.setBlockAndMetadata(world, 0, 6, -2, Blocks.field_150396_be, 3);
        for (k1 = -4; k1 <= 5; ++k1) {
            this.setBlockAndMetadata(world, -4, 6, k1, this.wood2Block, this.wood2Meta);
        }
        for (k1 = -1; k1 <= 5; ++k1) {
            this.setBlockAndMetadata(world, 3, 6, k1, this.wood2Block, this.wood2Meta);
        }
        this.setBlockAndMetadata(world, -2, 7, -4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, 1, 7, -4, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, -2, 7, 5, Blocks.field_150478_aa, 4);
        this.setBlockAndMetadata(world, 1, 7, 5, Blocks.field_150478_aa, 4);
        int carpet = random.nextInt(16);
        this.setBlockAndMetadata(world, -1, 6, 2, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, 0, 6, 2, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, -1, 6, 3, Blocks.field_150404_cg, carpet);
        this.setBlockAndMetadata(world, 0, 6, 3, Blocks.field_150404_cg, carpet);
        for (k12 = 4; k12 <= 5; ++k12) {
            for (j12 = 6; j12 <= 7; ++j12) {
                this.setBlockAndMetadata(world, -3, j12, k12, Blocks.field_150342_X, 0);
                this.setBlockAndMetadata(world, 2, j12, k12, Blocks.field_150342_X, 0);
            }
        }
        this.setBlockAndMetadata(world, -3, 6, 0, this.wood2Block, this.wood2Meta);
        this.setBlockAndMetadata(world, -3, 7, 0, LOTRWorldGenHobbitHole.getRandomFoodBlock(random), 0);
        this.setBlockAndMetadata(world, -3, 6, 1, (Block)Blocks.field_150383_bp, 3);
        this.setBlockAndMetadata(world, -3, 6, 2, LOTRMod.hobbitOven, 4);
        this.setBlockAndMetadata(world, -3, 6, 3, Blocks.field_150462_ai, 0);
        this.setBlockAndMetadata(world, 2, 6, 1, (Block)Blocks.field_150486_ae, 5);
        this.fillChest(world, random, 2, 6, 1, LOTRChestContents.HOBBIT_HOLE_LARDER);
        this.setBlockAndMetadata(world, 2, 6, 2, Blocks.field_150324_C, 0);
        this.setBlockAndMetadata(world, 2, 6, 3, Blocks.field_150324_C, 8);
        for (i1 = 5; i1 <= 10; ++i1) {
            this.setBlockAndMetadata(world, i1, 1, -5, Blocks.field_150422_aJ, 0);
            this.setBlockAndMetadata(world, i1, 1, 6, Blocks.field_150422_aJ, 0);
        }
        for (k12 = -4; k12 <= 5; ++k12) {
            this.setBlockAndMetadata(world, 10, 1, k12, Blocks.field_150422_aJ, 0);
        }
        this.setBlockAndMetadata(world, 7, 1, -5, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, 5, 2, -5, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, -5, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, -1, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, 2, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 5, 2, 6, Blocks.field_150478_aa, 5);
        this.setBlockAndMetadata(world, 10, 2, 6, Blocks.field_150478_aa, 5);
        for (i1 = 5; i1 <= 9; ++i1) {
            this.setBlockAndMetadata(world, i1, 0, -4, Blocks.field_150351_n, 0);
            this.setBlockAndMetadata(world, i1, 0, 5, Blocks.field_150351_n, 0);
        }
        for (k12 = -3; k12 <= 4; ++k12) {
            this.setBlockAndMetadata(world, 4, 0, k12, Blocks.field_150417_aV, 0);
            this.setBlockAndMetadata(world, 5, 0, k12, Blocks.field_150355_j, 0);
            this.setBlockAndMetadata(world, 5, 1, k12, (Block)Blocks.field_150333_U, 5);
            this.setBlockAndMetadata(world, 9, 0, k12, Blocks.field_150351_n, 0);
            for (i13 = 6; i13 <= 8; ++i13) {
                this.setBlockAndMetadata(world, i13, 0, k12, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i13, 1, k12, this.cropBlock, 7);
            }
        }
        LOTREntityHobbitFarmer farmer = new LOTREntityHobbitFarmer(world);
        this.spawnNPCAndSetHome(farmer, world, 0, 6, 0, 16);
        int farmhands = 1 + random.nextInt(3);
        for (int l = 0; l < farmhands; ++l) {
            LOTREntityHobbitFarmhand farmhand = new LOTREntityHobbitFarmhand(world);
            farmhand.seedsItem = this.seedItem;
            this.spawnNPCAndSetHome(farmhand, world, 7, 1, 0, 8);
        }
        int animals = 3 + random.nextInt(6);
        for (int l = 0; l < animals; ++l) {
            Class animalClass = ((BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)world.field_73012_v, (Collection)LOTRBiome.shire.func_76747_a((EnumCreatureType)EnumCreatureType.creature))).field_76300_b;
            EntityCreature animal = null;
            try {
                animal = (EntityCreature)animalClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            this.spawnNPCAndSetHome(animal, world, 0, 1, 0, 8);
        }
        return true;
    }
}

