/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNearHaradrimArcher;
import lotr.common.entity.npc.LOTREntityNearHaradrimWarrior;
import lotr.common.world.structure.LOTRChestContents;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class LOTRWorldGenNearHaradTower
extends LOTRWorldGenStructureBase2 {
    public LOTRWorldGenNearHaradTower(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        --j;
        int radius = 6;
        int radiusPlusOne = radius + 1;
        this.setRotationMode(rotation);
        switch (this.getRotationMode()) {
            case 0: {
                k += radiusPlusOne;
                break;
            }
            case 1: {
                i -= radiusPlusOne;
                break;
            }
            case 2: {
                k -= radiusPlusOne;
                break;
            }
            case 3: {
                i += radiusPlusOne;
            }
        }
        this.setOrigin(i, j, k);
        if (this.restrictions) {
            int minHeight = j;
            int maxHeight = j;
            for (int i1 = -radiusPlusOne; i1 <= radiusPlusOne; ++i1) {
                for (int k1 = -radiusPlusOne; k1 <= radiusPlusOne; ++k1) {
                    if (i1 * i1 + k1 * k1 > radiusPlusOne * radiusPlusOne) continue;
                    int j1 = this.getTopBlock(world, i1, k1) - 1;
                    Block block = this.getBlock(world, i1, j1, k1);
                    if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150354_m) {
                        return false;
                    }
                    if (j1 < minHeight) {
                        minHeight = j1;
                    }
                    if (j1 > maxHeight) {
                        maxHeight = j1;
                    }
                    if (maxHeight - minHeight <= 8) continue;
                    return false;
                }
            }
        }
        int sections = 3 + random.nextInt(2);
        int sectionHeight = 8;
        int topHeight = sections * sectionHeight;
        int wallThresholdMin = radius * radius;
        int wallThresholdMax = radiusPlusOne * radiusPlusOne;
        for (int i1 = -radius; i1 <= radius; ++i1) {
            for (int k1 = -radius; k1 <= radius; ++k1) {
                int distSq = i1 * i1 + k1 * k1;
                if (distSq >= wallThresholdMax) continue;
                for (int j1 = 0; !(j1 != 0 && this.isOpaque(world, i1, j1, k1) || this.getY(j1) < 0); --j1) {
                    if (j1 > 0 || distSq >= wallThresholdMin) {
                        this.setBlockAndMetadata(world, i1, j1, k1, LOTRMod.brick, 15);
                    } else {
                        this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150322_A, 2);
                    }
                    this.setGrassToDirt(world, i1, j1 - 1, k1);
                }
            }
        }
        for (int l = 0; l < sections; ++l) {
            int sectionBase = l * sectionHeight;
            for (int j1 = sectionBase + 1; j1 <= sectionBase + sectionHeight; ++j1) {
                for (int i1 = -radius; i1 <= radius; ++i1) {
                    for (int k1 = -radius; k1 <= radius; ++k1) {
                        int distSq = i1 * i1 + k1 * k1;
                        if (distSq >= wallThresholdMax) continue;
                        if (distSq >= wallThresholdMin) {
                            int i2 = Math.abs(i1);
                            int k2 = Math.abs(k1);
                            if (i2 == 3 && k2 == 6 || k2 == 3 && i2 == 6) {
                                this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150405_ch, 0);
                            } else if ((j1 - sectionBase) % (sectionHeight / 2) == 0) {
                                if (j1 != sectionBase + sectionHeight && (i2 == 1 && k2 == 6 || k2 == 1 && i2 == 6)) {
                                    this.setBlockAndMetadata(world, i1, j1, k1, LOTRMod.slabSingle4, 8);
                                    if (l > 0) {
                                        this.setAir(world, i1, j1 - 1, k1);
                                        this.setBlockAndMetadata(world, i1, j1 - 2, k1, Blocks.field_150322_A, 2);
                                    }
                                } else {
                                    this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150322_A, 2);
                                }
                            } else {
                                this.setBlockAndMetadata(world, i1, j1, k1, LOTRMod.brick, 15);
                            }
                            if (l == sections - 1 && j1 == sectionBase + sectionHeight) {
                                this.setBlockAndMetadata(world, i1, j1 + 1, k1, LOTRMod.brick, 15);
                                this.setBlockAndMetadata(world, i1, j1 + 2, k1, LOTRMod.wall, 15);
                                if (i2 == 3 && k2 == 6 || k2 == 3 && i2 == 6) {
                                    this.setBlockAndMetadata(world, i1, j1 + 3, k1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1, j1 + 4, k1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1 - 1, j1 + 4, k1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1 + 1, j1 + 4, k1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1, j1 + 4, k1 - 1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1, j1 + 4, k1 + 1, LOTRMod.wall, 15);
                                    this.setBlockAndMetadata(world, i1, j1 + 5, k1, LOTRMod.hearth, 0);
                                    this.setBlockAndMetadata(world, i1, j1 + 6, k1, (Block)Blocks.field_150480_ab, 0);
                                }
                            }
                        } else if (j1 == sectionBase + sectionHeight && (Math.abs(i1) > 2 || Math.abs(k1) > 2)) {
                            this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150322_A, 2);
                        } else {
                            this.setAir(world, i1, j1, k1);
                        }
                        this.setGrassToDirt(world, i1, j1 - 1, k1);
                    }
                }
                this.setBlockAndMetadata(world, 0, j1, 0, Blocks.field_150405_ch, 0);
            }
            for (int l1 = 0; l1 < 2; ++l1) {
                int stairBase = sectionBase + l1 * 4;
                this.setBlockAndMetadata(world, 0, stairBase + 1, 1, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, 0, stairBase + 1, 2, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, 1, stairBase + 2, 0, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, 2, stairBase + 2, 0, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, 0, stairBase + 3, -1, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, 0, stairBase + 3, -2, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, -1, stairBase + 4, 0, LOTRMod.slabSingle4, 0);
                this.setBlockAndMetadata(world, -2, stairBase + 4, 0, LOTRMod.slabSingle4, 0);
                for (int i1 = 0; i1 <= 1; ++i1) {
                    for (int k1 = 0; k1 <= 1; ++k1) {
                        this.setBlockAndMetadata(world, 1 + i1, stairBase + 1, 1 + k1, LOTRMod.slabSingle4, 8);
                        this.setBlockAndMetadata(world, 1 + i1, stairBase + 2, -2 + k1, LOTRMod.slabSingle4, 8);
                        this.setBlockAndMetadata(world, -2 + i1, stairBase + 3, -2 + k1, LOTRMod.slabSingle4, 8);
                        this.setBlockAndMetadata(world, -2 + i1, stairBase + 4, 1 + k1, LOTRMod.slabSingle4, 8);
                    }
                }
                this.setBlockAndMetadata(world, -1, stairBase + 2, 0, Blocks.field_150478_aa, 1);
                this.setBlockAndMetadata(world, 1, stairBase + 4, 0, Blocks.field_150478_aa, 2);
            }
            this.setBlockAndMetadata(world, -4, sectionBase + 4, -4, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, -4, sectionBase + 5, -4, Blocks.field_150478_aa, 5);
            this.setBlockAndMetadata(world, -4, sectionBase + 4, 4, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, -4, sectionBase + 5, 4, Blocks.field_150478_aa, 5);
            this.setBlockAndMetadata(world, 4, sectionBase + 4, -4, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, 4, sectionBase + 5, -4, Blocks.field_150478_aa, 5);
            this.setBlockAndMetadata(world, 4, sectionBase + 4, 4, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, 4, sectionBase + 5, 4, Blocks.field_150478_aa, 5);
            this.placeRandomFeature(world, random, 0, sectionBase + 1, 5, 0);
            this.placeRandomFeature(world, random, -5, sectionBase + 1, 0, 1);
            if (l > 0) {
                this.placeRandomFeature(world, random, 0, sectionBase + 1, -5, 2);
            }
            this.placeRandomFeature(world, random, 5, sectionBase + 1, 0, 3);
            LOTREntityNearHaradrimWarrior warrior = random.nextInt(3) == 0 ? new LOTREntityNearHaradrimArcher(world) : new LOTREntityNearHaradrimWarrior(world);
            warrior.spawnRidingHorse = false;
            this.spawnNPCAndSetHome(warrior, world, -3, sectionBase + 1, -3, 12);
        }
        this.setBlockAndMetadata(world, 0, topHeight + 1, -5, LOTRMod.slabSingle4, 8);
        this.placeBanner(world, 0, topHeight + 2, -5, 0, 9);
        this.setBlockAndMetadata(world, 5, topHeight + 1, 0, LOTRMod.slabSingle4, 8);
        this.placeBanner(world, 5, topHeight + 2, 0, 1, 9);
        this.setBlockAndMetadata(world, 0, topHeight + 1, 5, LOTRMod.slabSingle4, 8);
        this.placeBanner(world, 0, topHeight + 2, 5, 2, 9);
        this.setBlockAndMetadata(world, -5, topHeight + 1, 0, LOTRMod.slabSingle4, 8);
        this.placeBanner(world, -5, topHeight + 2, 0, 3, 9);
        this.setBlockAndMetadata(world, 0, 1, -6, Blocks.field_150466_ao, 1);
        this.setBlockAndMetadata(world, 0, 2, -6, Blocks.field_150466_ao, 8);
        this.placeWallBanner(world, 0, 7, -6, 2, 9);
        if (this.usingPlayer == null) {
            LOTRLevelData.nearHaradTowerLocations.add(new ChunkCoordinates(i, j, k));
        }
        return true;
    }

    private void placeRandomFeature(World world, Random random, int i, int j, int k, int direction) {
        int l = random.nextInt(7);
        if (l == 0 || l == 1) {
            this.setBlockAndMetadata(world, i, j, k, LOTRMod.brick, 15);
            if (random.nextInt(4) == 0) {
                this.placeArmorStand(world, i, j + 1, k, direction, new ItemStack[]{new ItemStack(LOTRMod.helmetNearHarad), new ItemStack(LOTRMod.bodyNearHarad), new ItemStack(LOTRMod.legsNearHarad), new ItemStack(LOTRMod.bootsNearHarad)});
            }
        }
        if (l == 2) {
            this.setBlockAndMetadata(world, i, j, k, LOTRMod.nearHaradTable, 0);
        }
        if (l == 3) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150462_ai, 0);
        }
        if (l == 4) {
            this.setBlockAndMetadata(world, i, j, k, (Block)Blocks.field_150486_ae, 0);
            this.fillChest(world, random, i, j, k, LOTRChestContents.NEAR_HARAD_TOWER);
        }
        if (l == 5) {
            this.setBlockAndMetadata(world, i, j, k, LOTRMod.brick, 15);
            this.placePlateWithCertainty(world, i, j + 1, k, random, LOTRFoods.NEAR_HARAD);
        }
        if (l == 6) {
            this.setBlockAndMetadata(world, i, j, k, LOTRMod.brick, 15);
            this.placeMug(world, random, i, j + 1, k, random.nextInt(4), LOTRMod.mugAraq);
        }
        if (direction == 0 || direction == 2) {
            this.setBlockAndMetadata(world, i - 1, j, k, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, i + 1, j, k, LOTRMod.wall, 15);
        } else {
            this.setBlockAndMetadata(world, i, j, k - 1, LOTRMod.wall, 15);
            this.setBlockAndMetadata(world, i, j, k + 1, LOTRMod.wall, 15);
        }
    }
}

