/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Collection;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.block.LOTRBlockOre;
import lotr.common.entity.LOTREntities;
import lotr.common.world.biome.LOTRBiome;
import lotr.common.world.feature.LOTRWorldGenDatePalm;
import lotr.common.world.structure2.LOTRWorldGenNearHaradBazaar;
import lotr.common.world.structure2.LOTRWorldGenNearHaradHouse;
import lotr.common.world.structure2.LOTRWorldGenNearHaradLargeHouse;
import lotr.common.world.structure2.LOTRWorldGenNearHaradTower;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTRWorldGenNearHaradVillage
extends LOTRWorldGenStructureBase2 {
    private static int HEIGHT_TOLERANCE;
    private static int BOUNDARY;
    private static int VILLAGE_SIZE;
    private static int VILLAGE_TOTAL_SIZE;
    private static int AIR_SET;

    public LOTRWorldGenNearHaradVillage(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int i1;
        int k1;
        int i12;
        int l;
        int k12;
        int k13;
        int i13;
        int i14;
        --j;
        this.setRotationMode(rotation);
        if (!this.restrictions && this.usingPlayer != null) {
            switch (this.getRotationMode()) {
                case 0: {
                    k += VILLAGE_SIZE + BOUNDARY + 1;
                    break;
                }
                case 1: {
                    i -= VILLAGE_SIZE + BOUNDARY + 1;
                    break;
                }
                case 2: {
                    k -= VILLAGE_SIZE + BOUNDARY + 1;
                    break;
                }
                case 3: {
                    i += VILLAGE_SIZE + BOUNDARY + 1;
                }
            }
        }
        this.setOrigin(i, j, k);
        if (this.restrictions) {
            int minHeight = this.getTopBlock(world, 0, 0);
            int maxHeight = this.getTopBlock(world, 0, 0);
            for (i14 = -VILLAGE_TOTAL_SIZE; i14 <= VILLAGE_TOTAL_SIZE; ++i14) {
                for (int k14 = -VILLAGE_TOTAL_SIZE; k14 <= VILLAGE_TOTAL_SIZE; ++k14) {
                    int i2 = this.getX(i14, k14);
                    int k2 = this.getZ(i14, k14);
                    int j1 = this.getTopBlock(world, i14, k14);
                    Block block = this.getBlock(world, i14, j1 - 1, k14);
                    int j2 = this.getY(j1 - 1);
                    if (!(block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150348_b || block == Blocks.field_150435_aG || block == Blocks.field_150351_n || block instanceof BlockOre || block instanceof LOTRBlockOre || block.isWood((IBlockAccess)world, i2, j2, k2) || block.isLeaves((IBlockAccess)world, i2, j2, k2) || block == Blocks.field_150423_aK)) {
                        return false;
                    }
                    int i3 = Math.abs(i14);
                    int k3 = Math.abs(k14);
                    if (i3 == VILLAGE_TOTAL_SIZE || k3 == VILLAGE_TOTAL_SIZE) {
                        if (j1 < minHeight) {
                            minHeight = j1;
                        }
                        if (j1 <= maxHeight) continue;
                        maxHeight = j1;
                        continue;
                    }
                    if (j1 - this.originY <= AIR_SET) continue;
                    maxHeight = j1;
                }
            }
            if (maxHeight - minHeight > HEIGHT_TOLERANCE) {
                return false;
            }
        }
        for (i13 = -VILLAGE_TOTAL_SIZE; i13 <= VILLAGE_TOTAL_SIZE; ++i13) {
            for (k13 = -VILLAGE_TOTAL_SIZE; k13 <= VILLAGE_TOTAL_SIZE; ++k13) {
                int j1;
                this.setBlockAndMetadata(world, i13, 0, k13, (Block)Blocks.field_150349_c, 0);
                for (j1 = 1; j1 <= AIR_SET; ++j1) {
                    this.setAir(world, i13, j1, k13);
                }
                j1 = -1;
                while (!this.isOpaque(world, i13, j1, k13) && this.getY(j1) >= 0) {
                    this.setBlockAndMetadata(world, i13, j1, k13, Blocks.field_150346_d, 0);
                    this.setGrassToDirt(world, i13, j1 - 1, k13);
                    --j1;
                }
            }
        }
        for (i13 = -VILLAGE_TOTAL_SIZE; i13 <= VILLAGE_TOTAL_SIZE; ++i13) {
            for (k13 = -VILLAGE_TOTAL_SIZE; k13 <= VILLAGE_TOTAL_SIZE; ++k13) {
                if (i13 == -VILLAGE_TOTAL_SIZE) {
                    this.terraformGround(world, i13, k13, -1, 0);
                }
                if (i13 == VILLAGE_TOTAL_SIZE) {
                    this.terraformGround(world, i13, k13, 1, 0);
                }
                if (k13 == -VILLAGE_TOTAL_SIZE) {
                    this.terraformGround(world, i13, k13, 0, -1);
                }
                if (k13 != VILLAGE_TOTAL_SIZE) continue;
                this.terraformGround(world, i13, k13, 0, 1);
            }
        }
        for (i13 = -3; i13 <= 3; ++i13) {
            for (k13 = -3; k13 <= 3; ++k13) {
                this.setBlockAndMetadata(world, i13, -1, k13, Blocks.field_150322_A, 2);
                this.setBlockAndMetadata(world, i13, 0, k13, Blocks.field_150322_A, 2);
            }
        }
        for (i13 = -1; i13 <= 1; ++i13) {
            for (k13 = -1; k13 <= 1; ++k13) {
                this.setBlockAndMetadata(world, i13, 0, k13, Blocks.field_150355_j, 0);
            }
        }
        for (int j1 = 1; j1 <= 4; ++j1) {
            this.setBlockAndMetadata(world, -2, j1, -2, Blocks.field_150322_A, 2);
            this.setBlockAndMetadata(world, -2, j1, 2, Blocks.field_150322_A, 2);
            this.setBlockAndMetadata(world, 2, j1, -2, Blocks.field_150322_A, 2);
            this.setBlockAndMetadata(world, 2, j1, 2, Blocks.field_150322_A, 2);
        }
        for (i13 = -2; i13 <= 2; ++i13) {
            for (k13 = -2; k13 <= 2; ++k13) {
                this.setBlockAndMetadata(world, i13, 5, k13, LOTRMod.brick, 15);
                if (Math.abs(i13) != 2 && Math.abs(k13) != 2) continue;
                this.setBlockAndMetadata(world, i13, 6, k13, LOTRMod.wall, 15);
            }
        }
        for (i13 = -2; i13 <= 2; i13 += 4) {
            this.setBlockAndMetadata(world, i13, 4, -1, LOTRMod.stairsNearHaradBrick, 7);
            this.setBlockAndMetadata(world, i13, 4, 0, LOTRMod.slabSingle4, 8);
            this.setBlockAndMetadata(world, i13, 4, 1, LOTRMod.stairsNearHaradBrick, 6);
        }
        for (k12 = -2; k12 <= 2; k12 += 4) {
            this.setBlockAndMetadata(world, -1, 4, k12, LOTRMod.stairsNearHaradBrick, 4);
            this.setBlockAndMetadata(world, 0, 4, k12, LOTRMod.slabSingle4, 8);
            this.setBlockAndMetadata(world, 1, 4, k12, LOTRMod.stairsNearHaradBrick, 5);
        }
        for (i13 = -1; i13 <= 1; ++i13) {
            this.setBlockAndMetadata(world, i13, 5, -1, LOTRMod.stairsNearHaradBrick, 7);
            this.setBlockAndMetadata(world, i13, 5, 1, LOTRMod.stairsNearHaradBrick, 6);
        }
        this.setBlockAndMetadata(world, -1, 5, 0, LOTRMod.stairsNearHaradBrick, 4);
        this.setBlockAndMetadata(world, 1, 5, 0, LOTRMod.stairsNearHaradBrick, 5);
        this.setBlockAndMetadata(world, 0, 5, 0, LOTRMod.slabSingle4, 8);
        this.setBlockAndMetadata(world, 0, 5, 0, Blocks.field_150346_d, 0);
        for (int l2 = 0; l2 < 20 && !new LOTRWorldGenDatePalm(this.notifyChanges).func_76484_a(world, random, this.getX(0, 0), this.getY(6), this.getZ(0, 0)); ++l2) {
        }
        this.setBlockAndMetadata(world, 0, 5, 0, LOTRMod.slabSingle4, 8);
        this.placeWallBanner(world, 0, 5, -2, 2, 9);
        this.placeWallBanner(world, 2, 5, 0, 1, 9);
        this.placeWallBanner(world, 0, 5, 2, 0, 9);
        this.placeWallBanner(world, -2, 5, 0, 3, 9);
        this.setBlockAndMetadata(world, -2, 2, -3, Blocks.field_150478_aa, 4);
        this.setBlockAndMetadata(world, 2, 2, -3, Blocks.field_150478_aa, 4);
        this.setBlockAndMetadata(world, -2, 2, 3, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, 2, 2, 3, Blocks.field_150478_aa, 3);
        this.setBlockAndMetadata(world, -3, 2, -2, Blocks.field_150478_aa, 1);
        this.setBlockAndMetadata(world, -3, 2, 2, Blocks.field_150478_aa, 1);
        this.setBlockAndMetadata(world, 3, 2, -2, Blocks.field_150478_aa, 2);
        this.setBlockAndMetadata(world, 3, 2, 2, Blocks.field_150478_aa, 2);
        for (i13 = 4; i13 <= 27; ++i13) {
            this.setBlockAndMetadata(world, i13, 0, -1, LOTRMod.brick, 15);
            this.setBlockAndMetadata(world, i13, 0, 0, Blocks.field_150406_ce, 14);
            this.setBlockAndMetadata(world, i13, 0, 1, LOTRMod.brick, 15);
            if (i13 != 13 && i13 != 21) continue;
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(i13, 2), this.getY(1), this.getZ(i13, 2), (this.getRotationMode() + 0) % 4);
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(i13, -2), this.getY(1), this.getZ(i13, -2), (this.getRotationMode() + 2) % 4);
        }
        for (k12 = -4; k12 >= -27; --k12) {
            this.setBlockAndMetadata(world, -1, 0, k12, LOTRMod.brick, 15);
            this.setBlockAndMetadata(world, 0, 0, k12, Blocks.field_150406_ce, 4);
            this.setBlockAndMetadata(world, 1, 0, k12, LOTRMod.brick, 15);
            if (k12 != -13 && k12 != -21) continue;
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(2, k12), this.getY(1), this.getZ(2, k12), (this.getRotationMode() + 1) % 4);
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(-2, k12), this.getY(1), this.getZ(-2, k12), (this.getRotationMode() + 3) % 4);
        }
        for (i13 = -4; i13 >= -27; --i13) {
            this.setBlockAndMetadata(world, i13, 0, -1, LOTRMod.brick, 15);
            this.setBlockAndMetadata(world, i13, 0, 0, Blocks.field_150406_ce, 13);
            this.setBlockAndMetadata(world, i13, 0, 1, LOTRMod.brick, 15);
            if (i13 != -13 && i13 != -21) continue;
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(i13, 2), this.getY(1), this.getZ(i13, 2), (this.getRotationMode() + 0) % 4);
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(i13, -2), this.getY(1), this.getZ(i13, -2), (this.getRotationMode() + 2) % 4);
        }
        for (k12 = 4; k12 <= 27; ++k12) {
            this.setBlockAndMetadata(world, -1, 0, k12, LOTRMod.brick, 15);
            this.setBlockAndMetadata(world, 0, 0, k12, Blocks.field_150406_ce, 3);
            this.setBlockAndMetadata(world, 1, 0, k12, LOTRMod.brick, 15);
            if (k12 != 13 && k12 != 21) continue;
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(2, k12), this.getY(1), this.getZ(2, k12), (this.getRotationMode() + 1) % 4);
            this.getRandomHouseGen(random).generateWithSetRotation(world, random, this.getX(-2, k12), this.getY(1), this.getZ(-2, k12), (this.getRotationMode() + 3) % 4);
        }
        for (i13 = -8; i13 <= -3; ++i13) {
            this.setBlockAndMetadata(world, i13, 1, -8, LOTRMod.fence, 14);
        }
        for (k12 = -7; k12 <= -3; ++k12) {
            this.setBlockAndMetadata(world, -8, 1, k12, LOTRMod.fence, 14);
        }
        this.setBlockAndMetadata(world, -7, 1, -3, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, -6, 1, -3, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, -5, 1, -3, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, -5, 1, -4, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, -5, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, -4, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, -3, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, -3, 1, -6, Blocks.field_150396_be, 1);
        this.setBlockAndMetadata(world, -3, 1, -7, Blocks.field_150396_be, 1);
        int animals = 1 + random.nextInt(3);
        for (l = 0; l < animals; ++l) {
            this.spawnNPCAndSetHome(this.getRandomHaradAnimal(world, random), world, -6, 1, -6, 16);
        }
        for (i12 = 3; i12 <= 8; ++i12) {
            this.setBlockAndMetadata(world, i12, 1, -8, LOTRMod.fence, 14);
        }
        for (k13 = -7; k13 <= -3; ++k13) {
            this.setBlockAndMetadata(world, 8, 1, k13, LOTRMod.fence, 14);
        }
        this.setBlockAndMetadata(world, 7, 1, -3, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, 6, 1, -3, Blocks.field_150396_be, 0);
        this.setBlockAndMetadata(world, 5, 1, -3, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, 5, 1, -4, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, 5, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, 4, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, 3, 1, -5, LOTRMod.fence, 14);
        this.setBlockAndMetadata(world, 3, 1, -6, Blocks.field_150396_be, 1);
        this.setBlockAndMetadata(world, 3, 1, -7, Blocks.field_150396_be, 1);
        animals = 1 + random.nextInt(3);
        for (l = 0; l < animals; ++l) {
            this.spawnNPCAndSetHome(this.getRandomHaradAnimal(world, random), world, 6, 1, -6, 16);
        }
        for (i12 = -8; i12 <= -3; ++i12) {
            this.setBlockAndMetadata(world, i12, 1, 8, Blocks.field_150322_A, 2);
        }
        for (k13 = 3; k13 <= 7; ++k13) {
            this.setBlockAndMetadata(world, -8, 1, k13, Blocks.field_150322_A, 2);
        }
        this.setBlockAndMetadata(world, -7, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -6, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -5, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -5, 1, 4, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -5, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -4, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -3, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -3, 1, 6, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, -3, 1, 7, Blocks.field_150322_A, 2);
        Block crop = this.getRandomCropBlock(random);
        for (k1 = 4; k1 <= 7; ++k1) {
            for (i1 = -7; i1 <= -6; ++i1) {
                this.setBlockAndMetadata(world, i1, 1, k1, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i1, 2, k1, crop, 7);
            }
        }
        for (k1 = 6; k1 <= 7; ++k1) {
            for (i1 = -5; i1 <= -4; ++i1) {
                this.setBlockAndMetadata(world, i1, 1, k1, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i1, 2, k1, crop, 7);
            }
        }
        this.setBlockAndMetadata(world, -7, 2, 7, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, -7, 1, 7, Blocks.field_150355_j, 0);
        this.setBlockAndMetadata(world, -8, 2, 7, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, -8, 2, 8, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, -7, 2, 8, LOTRMod.slabSingle4, 0);
        for (i14 = 3; i14 <= 8; ++i14) {
            this.setBlockAndMetadata(world, i14, 1, 8, Blocks.field_150322_A, 2);
        }
        for (k1 = 3; k1 <= 7; ++k1) {
            this.setBlockAndMetadata(world, 8, 1, k1, Blocks.field_150322_A, 2);
        }
        this.setBlockAndMetadata(world, 7, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 6, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 5, 1, 3, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 5, 1, 4, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 5, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 4, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 3, 1, 5, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 3, 1, 6, Blocks.field_150322_A, 2);
        this.setBlockAndMetadata(world, 3, 1, 7, Blocks.field_150322_A, 2);
        crop = this.getRandomCropBlock(random);
        for (k1 = 4; k1 <= 7; ++k1) {
            for (i1 = 6; i1 <= 7; ++i1) {
                this.setBlockAndMetadata(world, i1, 1, k1, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i1, 2, k1, crop, 7);
            }
        }
        for (k1 = 6; k1 <= 7; ++k1) {
            for (i1 = 4; i1 <= 5; ++i1) {
                this.setBlockAndMetadata(world, i1, 1, k1, Blocks.field_150458_ak, 7);
                this.setBlockAndMetadata(world, i1, 2, k1, crop, 7);
            }
        }
        this.setBlockAndMetadata(world, 7, 2, 7, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, 7, 1, 7, Blocks.field_150355_j, 0);
        this.setBlockAndMetadata(world, 8, 2, 7, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, 8, 2, 8, LOTRMod.slabSingle4, 0);
        this.setBlockAndMetadata(world, 7, 2, 8, LOTRMod.slabSingle4, 0);
        this.getRandomCornerStructure(random).generateWithSetRotation(world, random, this.getX(-18, -25), this.getY(1), this.getZ(-18, -25), (this.getRotationMode() + 0) % 4);
        this.getRandomCornerStructure(random).generateWithSetRotation(world, random, this.getX(18, -25), this.getY(1), this.getZ(18, -25), (this.getRotationMode() + 0) % 4);
        this.getRandomCornerStructure(random).generateWithSetRotation(world, random, this.getX(-18, 25), this.getY(1), this.getZ(-18, 25), (this.getRotationMode() + 2) % 4);
        this.getRandomCornerStructure(random).generateWithSetRotation(world, random, this.getX(18, 25), this.getY(1), this.getZ(18, 25), (this.getRotationMode() + 2) % 4);
        return true;
    }

    private void terraformGround(World world, int i, int k, int xDirection, int zDirection) {
        int j1;
        int k1;
        int i1;
        int l;
        int difference;
        int height = this.getTopBlock(world, i + xDirection, k + zDirection) - 1;
        int actualHeight = this.getY(height);
        if (actualHeight > this.originY) {
            difference = actualHeight - this.originY;
            difference = Math.min(difference, HEIGHT_TOLERANCE);
            for (l = 0; l < HEIGHT_TOLERANCE; ++l) {
                int maxElevation = Math.min(l + 1, difference);
                i1 = i - xDirection * (BOUNDARY - 1 - l);
                k1 = k - zDirection * (BOUNDARY - 1 - l);
                for (j1 = 1; j1 <= maxElevation; ++j1) {
                    if (j1 == maxElevation) {
                        this.setBlockAndMetadata(world, i1, j1, k1, (Block)Blocks.field_150349_c, 0);
                        continue;
                    }
                    this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150346_d, 0);
                }
                this.setGrassToDirt(world, i1, 0, k1);
            }
        }
        if (actualHeight < this.originY) {
            difference = Math.abs(this.originY - actualHeight);
            difference = Math.min(difference, HEIGHT_TOLERANCE);
            for (l = 0; l < HEIGHT_TOLERANCE; ++l) {
                int minElevation = Math.max(-l - 1, -difference);
                i1 = i - xDirection * (BOUNDARY - 1 - l);
                k1 = k - zDirection * (BOUNDARY - 1 - l);
                for (j1 = 0; j1 >= minElevation; --j1) {
                    if (j1 == minElevation && this.isOpaque(world, i1, j1, k1)) {
                        this.setBlockAndMetadata(world, i1, j1, k1, (Block)Blocks.field_150349_c, 0);
                        continue;
                    }
                    this.setAir(world, i1, j1, k1);
                }
            }
        }
    }

    private LOTRWorldGenStructureBase2 getRandomHouseGen(Random random) {
        LOTRWorldGenNearHaradHouse houseGen = new LOTRWorldGenNearHaradHouse(this.notifyChanges);
        houseGen.restrictions = false;
        houseGen.usingPlayer = this.usingPlayer;
        return houseGen;
    }

    private LOTRWorldGenStructureBase2 getRandomCornerStructure(Random random) {
        LOTRWorldGenStructureBase2 structure = null;
        structure = random.nextBoolean() ? (random.nextBoolean() ? new LOTRWorldGenNearHaradTower(this.notifyChanges) : new LOTRWorldGenNearHaradBazaar(this.notifyChanges)) : new LOTRWorldGenNearHaradLargeHouse(this.notifyChanges);
        structure.restrictions = false;
        structure.usingPlayer = this.usingPlayer;
        return structure;
    }

    private EntityCreature getRandomHaradAnimal(World world, Random random) {
        Class animalClass = ((BiomeGenBase.SpawnListEntry)WeightedRandom.func_76271_a((Random)random, (Collection)LOTRBiome.nearHaradFertile.func_76747_a((EnumCreatureType)EnumCreatureType.creature))).field_76300_b;
        EntityCreature animal = (EntityCreature)LOTREntities.createEntityByClass(animalClass, world);
        return animal;
    }

    private Block getRandomCropBlock(Random random) {
        int l = random.nextInt(4);
        if (l == 0) {
            return Blocks.field_150464_aj;
        }
        if (l == 1) {
            return Blocks.field_150459_bM;
        }
        if (l == 2) {
            return Blocks.field_150469_bN;
        }
        return LOTRMod.lettuceCrop;
    }

    static {
        BOUNDARY = HEIGHT_TOLERANCE = 5;
        VILLAGE_SIZE = 27;
        VILLAGE_TOTAL_SIZE = VILLAGE_SIZE + BOUNDARY;
        AIR_SET = 16;
    }
}

