/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.world.feature.LOTRWorldGenBigTrees;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;

public class LOTRWorldGenNumenorRuin
extends LOTRWorldGenStructureBase2 {
    public LOTRWorldGenNumenorRuin(boolean flag) {
        super(flag);
    }

    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int k1;
        int i1;
        if (this.restrictions && world.func_147439_a(i, j - 1, k) != Blocks.field_150349_c) {
            return false;
        }
        --j;
        int width = 3 + random.nextInt(3);
        this.setRotationMode(rotation);
        switch (this.getRotationMode()) {
            case 0: {
                k += width + 1;
                break;
            }
            case 1: {
                i -= width + 1;
                break;
            }
            case 2: {
                k -= width + 1;
                break;
            }
            case 3: {
                i += width + 1;
            }
        }
        this.setOrigin(i, j, k);
        for (i1 = -width; i1 <= width; ++i1) {
            for (k1 = -width; k1 <= width; ++k1) {
                int j1;
                if (Math.abs(i1) == width || Math.abs(k1) == width) {
                    j1 = 0;
                    while (!this.isOpaque(world, i1, j1, k1) && this.getY(j1) >= 0) {
                        this.placeRandomBrick(world, random, i1, j1, k1);
                        this.setGrassToDirt(world, i1, j1 - 1, k1);
                        --j1;
                    }
                    continue;
                }
                this.setBlockAndMetadata(world, i1, 0, k1, (Block)Blocks.field_150349_c, 0);
                j1 = -1;
                while (!this.isOpaque(world, i1, j1, k1) && this.getY(j1) >= 0) {
                    this.setBlockAndMetadata(world, i1, j1, k1, Blocks.field_150346_d, 0);
                    this.setGrassToDirt(world, i1, j1 - 1, k1);
                    --j1;
                }
            }
        }
        if (random.nextBoolean()) {
            new WorldGenBigTree(this.notifyChanges).func_76484_a(world, random, this.originX, this.originY + 1, this.originZ);
        } else {
            LOTRWorldGenBigTrees.newBeech(this.notifyChanges).func_76484_a(world, random, this.originX, this.originY + 1, this.originZ);
        }
        for (i1 = -width; i1 <= width; ++i1) {
            for (k1 = -width; k1 <= width; ++k1) {
                if (Math.abs(i1) != width && Math.abs(k1) != width) continue;
                int height = width * 2 + random.nextInt(8);
                for (int j1 = 1; j1 < height; ++j1) {
                    this.placeRandomBrick(world, random, i1, j1, k1);
                }
            }
        }
        this.setAir(world, 0, 1, -width);
        this.setAir(world, 0, 2, -width);
        int ruins = 10 + random.nextInt(20);
        for (int l = 0; l < ruins; ++l) {
            int k12;
            int j1;
            int i12 = -width * 2 + random.nextInt(width * 2 + 1);
            Block block = this.getBlock(world, i12, (j1 = this.getTopBlock(world, i12, k12 = -width * 2 + random.nextInt(width * 2 + 1))) - 1, k12);
            if (block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b) continue;
            int l1 = random.nextInt(3);
            if (l1 == 0) {
                this.setBlockAndMetadata(world, i12, j1 - 1, k12, Blocks.field_150351_n, 0);
                continue;
            }
            if (l1 == 1) {
                this.placeRandomBrick(world, random, i12, j1 - 1, k12);
                continue;
            }
            if (l1 != 2) continue;
            int height = 1 + random.nextInt(3);
            for (int j2 = j1; j2 < j1 + height && !this.isOpaque(world, i12, j2, k12); ++j2) {
                this.placeRandomBrick(world, random, i12, j2, k12);
            }
        }
        return true;
    }

    private void placeRandomBrick(World world, Random random, int i, int j, int k) {
        int l = random.nextInt(5);
        if (l == 0) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150417_aV, 0);
        } else if (l == 1) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150417_aV, 1);
        } else if (l == 2) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150417_aV, 2);
        } else if (l == 3) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150347_e, 0);
        } else if (l == 4) {
            this.setBlockAndMetadata(world, i, j, k, Blocks.field_150341_Y, 0);
        }
    }
}

