/*
 * Decompiled with CFR 0.152.
 */
package RCM.Entities;

import RCM.Entities.PhysicsHelper;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class WingHandler {
    private PhysicsHelper helper = new PhysicsHelper();
    public Vector3f spanVect;
    public Vector3f liftVect;
    public Vector3f positionVect;
    private float lift;
    private float drag;
    private float span;
    private float root;
    private float aspectRatio;
    private float taperRatio;
    private float liftGradient;
    private float liftOffset;
    private float sectionLength;
    private float stallAngle;
    private float forcePos;
    private int sections = 10;
    private float[] sectionAreas;
    private float[] sectionSpans;

    public WingHandler(boolean flipSpan, boolean flipLift, Quat4f rotate, Vector3f pos, float wingRoot, float wingSpan, float wingAspectRatio, float wingTaperRatio, float wingStallAngle, float wingLiftGradient, float wingLiftOffset, boolean isProp) {
        if (isProp) {
            this.sections = 5;
        }
        int fSpan = 1;
        int fLift = 1;
        boolean fDrag = true;
        if (flipSpan) {
            fSpan = -1;
        }
        if (flipLift) {
            fLift = -1;
        }
        this.spanVect = new Vector3f(this.helper.rotateVector(rotate, new Vector3f(0.0f, (float)fSpan, 0.0f)));
        this.liftVect = new Vector3f(this.helper.rotateVector(rotate, new Vector3f((float)fLift, 0.0f, 0.0f)));
        this.positionVect = new Vector3f(pos);
        this.root = wingRoot;
        this.span = wingSpan;
        this.aspectRatio = wingAspectRatio;
        this.taperRatio = wingTaperRatio;
        this.stallAngle = wingStallAngle;
        this.liftGradient = wingLiftGradient;
        this.liftOffset = wingLiftOffset;
        this.sectionLength = wingSpan / (float)this.sections;
        this.sectionAreas = new float[this.sections];
        this.sectionSpans = new float[this.sections];
        this.calculateWingSectionAreas();
    }

    private void calculateWingSectionAreas() {
        float totalArea = this.span * this.span / this.aspectRatio;
        float sectionSpan = this.sectionLength / 2.0f;
        for (int i = 0; i < this.sections; ++i) {
            float sectionCord = 2.0f * totalArea / ((1.0f + this.taperRatio) * this.span) * (1.0f - 2.0f * (1.0f - this.taperRatio) * sectionSpan / this.span);
            this.sectionAreas[i] = this.sectionLength * sectionCord;
            this.sectionSpans[i] = sectionSpan;
            sectionSpan += this.sectionLength;
        }
    }

    public void update(Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel, float density, float angle) {
        float totalMoment = 0.0f;
        float totalLiftForce = 0.0f;
        float totalDragForce = 0.0f;
        for (int i = 0; i < this.sections; ++i) {
            Vector3f wingRelAir = new Vector3f();
            Vector3f sectionVect = new Vector3f(this.spanVect);
            sectionVect.scale(this.sectionSpans[i]);
            sectionVect.add((Tuple3f)this.positionVect);
            wingRelAir.set((Tuple3f)this.helper.getVelocityAtPoint(localQuat, linearVel, rotationalVel, sectionVect));
            wingRelAir.scale(-1.0f);
            Quat4f deflection = new Quat4f();
            deflection.set(new AxisAngle4f(this.spanVect, angle));
            Vector3f deflSurface = new Vector3f(this.helper.rotateVector(deflection, this.liftVect));
            float airVelc = wingRelAir.length();
            airVelc *= airVelc;
            float angleOfAttack = this.helper.getAoA(deflSurface, localQuat, wingRelAir);
            float wingLiftCoef = this.liftGradient * angleOfAttack + this.liftOffset;
            float liftForce = wingLiftCoef * 0.5f * density * airVelc * this.sectionAreas[i];
            float wingDragCoef = 0.5f * (wingLiftCoef * wingLiftCoef) / ((float)Math.PI * this.aspectRatio);
            float dragForce = wingDragCoef * 0.5f * density * airVelc * this.sectionAreas[i];
            if (Math.abs(angleOfAttack) > this.stallAngle) {
                liftForce *= 0.25f;
                dragForce *= 1.4f;
            }
            totalMoment += liftForce * this.sectionSpans[i];
            totalLiftForce += liftForce;
            totalDragForce += dragForce;
        }
        this.lift = totalLiftForce;
        this.drag = totalDragForce;
        if (totalLiftForce != 0.0f) {
            this.forcePos = totalMoment / totalLiftForce;
        }
    }

    public Vector3f getLift() {
        Vector3f liftForce = new Vector3f(this.liftVect);
        liftForce.scale(this.lift);
        return liftForce;
    }

    public Vector3f getDrag(Quat4f localQuat, Vector3f linearVelc) {
        Vector3f dragForce = new Vector3f(linearVelc);
        if (dragForce.length() > 0.0f) {
            dragForce.normalize();
        }
        dragForce.scale(-this.drag);
        return dragForce;
    }

    public Vector3f getPosition() {
        Vector3f forcePostion = new Vector3f(this.spanVect);
        forcePostion.scale(this.forcePos);
        forcePostion.add((Tuple3f)this.positionVect);
        return forcePostion;
    }
}

