/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockAndMeta;
import assets.generator.Building;
import assets.generator.TemplateRule;
import assets.generator.WorldGeneratorThread;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;

public class BuildingDispenserTrap
extends Building {
    public static final int ARROW_MISSILE = 0;
    public static final int DAMAGE_POTION_MISSILE = 1;
    private static BlockAndMeta[] CODE_TO_BLOCK = new BlockAndMeta[]{PRESERVE_BLOCK, null, new BlockAndMeta(Blocks.field_150350_a, 0), new BlockAndMeta((Block)Blocks.field_150488_af, 0), new BlockAndMeta(Blocks.field_150429_aA, BUTTON_DIR_TO_META[0]), new BlockAndMeta(Blocks.field_150437_az, BUTTON_DIR_TO_META[2]), new BlockAndMeta(Blocks.field_150429_aA, 5)};
    private static int[][][] MECHANISM = new int[][][]{new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 1, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {1, 1, 1}, {1, 4, 1}, {1, 1, 1}}, new int[][]{{0, 0, 0}, {1, 1, 1}, {1, 1, 1}, {1, 5, 1}}, new int[][]{{0, 1, 0}, {1, 1, 1}, {1, 3, 1}, {1, 1, 1}}, new int[][]{{0, 1, 0}, {1, 6, 1}, {1, 0, 1}, {1, 2, 1}}, new int[][]{{0, 1, 0}, {1, 1, 1}, {1, 1, 1}, {1, 1, 1}}};

    public BuildingDispenserTrap(WorldGeneratorThread wgt_, TemplateRule bRule_, int bDir_, int plateSeparation, int[] sourcePt) {
        super(0, wgt_, bRule_, bDir_, 1, true, new int[]{3, 6, plateSeparation}, sourcePt);
    }

    public void build(int missileType, boolean multipleTriggers) {
        if (this.bLength < 0) {
            this.bLength = 0;
        }
        for (int x = 0; x < MECHANISM[0][0].length; ++x) {
            for (int y = 0; y < MECHANISM[0].length; ++y) {
                for (int z = 0; z < MECHANISM.length; ++z) {
                    if (MECHANISM[z][3 - y][x] == 1) {
                        this.setBlockLocal(x, z - 3, y + this.bLength, this.bRule);
                        continue;
                    }
                    this.setBlockLocal(x, z - 3, y + this.bLength, CODE_TO_BLOCK[MECHANISM[z][3 - y][x]]);
                }
            }
        }
        for (int y = 0; y < this.bLength; ++y) {
            this.setBlockLocal(1, -3, y, this.bRule);
            this.setBlockLocal(1, -2, y, (Block)Blocks.field_150488_af);
            this.setBlockLocal(0, -2, y, this.bRule);
            this.setBlockLocal(2, -2, y, this.bRule);
            this.setBlockLocal(1, -1, y, this.bRule);
            this.setBlockLocal(1, 0, y, multipleTriggers && this.random.nextBoolean() ? Blocks.field_150456_au : Blocks.field_150350_a);
            this.setBlockLocal(1, 1, y, Blocks.field_150350_a);
        }
        this.setBlockLocal(1, 0, 0, Blocks.field_150456_au);
        this.flushDelayed();
        ItemStack itemstack = missileType == 0 ? new ItemStack(Items.field_151032_g, 30 + this.random.nextInt(10), 0) : new ItemStack((Item)Items.field_151068_bn, 30 + this.random.nextInt(10), 16396);
        this.setItemDispenser(1, 1, this.bLength + 1, 2, itemstack);
    }

    public boolean queryCanBuild(int minLength) {
        if (!this.isFloor(1, 0, 0)) {
            return false;
        }
        for (int y = 1; y < 9; ++y) {
            if (this.isFloor(1, 0, y)) continue;
            if (!this.isWallBlock(1, -1, y)) {
                return false;
            }
            if (y < minLength) {
                return false;
            }
            if (!this.isWallable(1, 1, y)) {
                this.bLength = y;
                return true;
            }
            return false;
        }
        return false;
    }

    private void setItemDispenser(int x, int z, int y, int metaDir, ItemStack itemstack) {
        int[] pt = this.getIJKPt(x, z, y);
        this.world.func_147465_d(pt[0], pt[1], pt[2], Blocks.field_150367_z, 0, 2);
        this.world.func_72921_c(pt[0], pt[1], pt[2], LADDER_DIR_TO_META[this.orientDirToBDir(metaDir)], 3);
        try {
            TileEntityDispenser tileentitychest = (TileEntityDispenser)this.world.func_147438_o(pt[0], pt[1], pt[2]);
            if (itemstack != null && tileentitychest != null) {
                tileentitychest.func_70299_a(this.random.nextInt(tileentitychest.func_70302_i_()), itemstack);
            }
        }
        catch (Exception e) {
            System.err.println("Error filling dispenser: " + e.toString());
            e.printStackTrace();
        }
    }
}

