/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BuildingCellularAutomaton;
import assets.generator.BuildingExplorationHandler;
import assets.generator.CommandBuild;
import assets.generator.CommandScan;
import assets.generator.TemplateRule;
import assets.generator.WorldGenCARuins;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

@Mod(modid="CARuins", name="Cellular Automata Generator", version="0.1.6", dependencies="after:ExtraBiomes,BiomesOPlenty", acceptableRemoteVersions="*")
public class PopulatorCARuins
extends BuildingExplorationHandler {
    @Mod.Instance(value="CARuins")
    public static PopulatorCARuins instance;
    private static final String AUTOMATA_RULES_STRING = "AUTOMATA RULES";
    private static final TemplateRule DEFAULT_TEMPLATE;
    private static TemplateRule[] DEFAULT_BLOCK_RULES;
    private static String[] BLOCK_RULE_NAMES;
    private static final String[] SPAWNER_RULE_NAMES;
    public static final String[][] DEFAULT_CA_RULES;
    public static final String[] SEED_TYPE_STRINGS;
    public int[] seedTypeWeights = new int[]{8, 2, 2, 1};
    public float SymmetricSeedDensity = 0.5f;
    public int MinHeight = 20;
    public int MaxHeight = 70;
    public int ContainerWidth = 40;
    public int ContainerLength = 40;
    public int MinHeightBeforeOscillation = 12;
    public boolean SmoothWithStairs = true;
    public boolean MakeFloors = true;
    public TemplateRule[] blockRules = new TemplateRule[DEFAULT_BLOCK_RULES.length];
    public TemplateRule[] spawnerRules = new TemplateRule[]{BuildingCellularAutomaton.DEFAULT_MEDIUM_LIGHT_NARROW_SPAWNER_RULE, BuildingCellularAutomaton.DEFAULT_MEDIUM_LIGHT_WIDE_SPAWNER_RULE, BuildingCellularAutomaton.DEFAULT_LOW_LIGHT_SPAWNER_RULE};
    ArrayList<byte[][]> caRules = null;
    int[][] caRulesWeightsAndIndex = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.settingsFileName = "CARuinsSettings.txt";
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/Generatormods/master/update.xml", "https://raw.github.com/GotoLink/Generatormods/master/changelog.md");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBuild());
        event.registerServerCommand((ICommand)new CommandScan());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataFiles() {
        try {
            this.initializeLogging("Loading options for the Cellular Automata Generator.");
            for (int i = 0; i < BIOME_NAMES.length; ++i) {
                if (BIOME_NAMES[i] == null) continue;
                if (i > 21) {
                    PopulatorCARuins.DEFAULT_BLOCK_RULES[i] = DEFAULT_TEMPLATE;
                }
                PopulatorCARuins.BLOCK_RULE_NAMES[i] = BIOME_NAMES[i].replaceAll("\\s", "") + "BlockRule";
            }
            this.caRules = new ArrayList();
            this.getGlobalOptions();
            this.finalizeLoading(false, "ruin");
        }
        catch (Exception e) {
            this.errFlag = true;
            this.logOrPrint("There was a problem loading the Cellular Automata Generator: " + e.getMessage(), "SEVERE");
            this.lw.println("There was a problem loading the Cellular Automata Generator: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (this.lw != null) {
                this.lw.close();
            }
        }
        if ((double)this.GlobalFrequency < 1.0E-6 || this.caRules == null || this.caRules.size() == 0) {
            this.errFlag = true;
        }
        this.dataFilesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadGlobalOptions(BufferedReader br) {
        ArrayList<Integer> caRuleWeights = new ArrayList<Integer>();
        try {
            String read = br.readLine();
            while (read != null) {
                int m;
                this.readGlobalOptions(this.lw, read);
                if (read.startsWith("MinHeight")) {
                    this.MinHeight = PopulatorCARuins.readIntParam(this.lw, this.MinHeight, ":", read);
                }
                if (read.startsWith("MaxHeight")) {
                    this.MaxHeight = PopulatorCARuins.readIntParam(this.lw, this.MaxHeight, ":", read);
                }
                if (read.startsWith("MinHeightBeforeOscillation")) {
                    this.MinHeightBeforeOscillation = PopulatorCARuins.readIntParam(this.lw, this.MinHeightBeforeOscillation, ":", read);
                }
                if (read.startsWith("SmoothWithStairs")) {
                    this.SmoothWithStairs = PopulatorCARuins.readBooleanParam(this.lw, this.SmoothWithStairs, ":", read);
                }
                if (read.startsWith("MakeFloors")) {
                    this.MakeFloors = PopulatorCARuins.readBooleanParam(this.lw, this.MakeFloors, ":", read);
                }
                if (read.startsWith("ContainerWidth")) {
                    this.ContainerWidth = PopulatorCARuins.readIntParam(this.lw, this.ContainerWidth, ":", read);
                }
                if (read.startsWith("ContainerLength")) {
                    this.ContainerLength = PopulatorCARuins.readIntParam(this.lw, this.ContainerLength, ":", read);
                }
                this.readChestItemsList(this.lw, read, br);
                if (read.startsWith("SymmetricSeedDensity")) {
                    this.SymmetricSeedDensity = PopulatorCARuins.readFloatParam(this.lw, this.SymmetricSeedDensity, ":", read);
                }
                for (m = 0; m < SEED_TYPE_STRINGS.length; ++m) {
                    if (!read.startsWith(SEED_TYPE_STRINGS[m])) continue;
                    this.seedTypeWeights[m] = PopulatorCARuins.readIntParam(this.lw, this.seedTypeWeights[m], ":", read);
                }
                for (m = 0; m < this.spawnerRules.length; ++m) {
                    if (!read.startsWith(SPAWNER_RULE_NAMES[m])) continue;
                    try {
                        this.spawnerRules[m] = this.readRuleIdOrRule(":", read, null);
                        continue;
                    }
                    catch (Exception e) {
                        this.spawnerRules[m] = BuildingCellularAutomaton.DEFAULT_MEDIUM_LIGHT_NARROW_SPAWNER_RULE;
                        this.lw.println(e.getMessage());
                    }
                }
                for (m = 0; m < DEFAULT_BLOCK_RULES.length; ++m) {
                    if (BIOME_NAMES[m] == null || !read.startsWith(BLOCK_RULE_NAMES[m])) continue;
                    try {
                        this.blockRules[m] = this.readRuleIdOrRule(":", read, null);
                        continue;
                    }
                    catch (Exception e) {
                        this.blockRules[m] = DEFAULT_BLOCK_RULES[m];
                        this.lw.println(e.getMessage());
                    }
                }
                if (read.startsWith(AUTOMATA_RULES_STRING)) {
                    read = br.readLine();
                    while (read != null) {
                        if (read.startsWith("B") || read.startsWith("b")) {
                            String[] splitStr = read.split(",");
                            this.caRules.add(BuildingCellularAutomaton.parseCARule(splitStr[0], this.lw));
                            caRuleWeights.add(PopulatorCARuins.readIntParam(this.lw, 1, "=", splitStr[1].trim()));
                        }
                        read = br.readLine();
                    }
                    break;
                }
                read = br.readLine();
            }
            if (this.TriesPerChunk > 100) {
                this.TriesPerChunk = 100;
            }
        }
        catch (IOException e) {
            this.lw.println(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setRulesWeightAndIndex(caRuleWeights);
    }

    private void setRulesWeightAndIndex(ArrayList<Integer> caRuleWeights) {
        this.caRulesWeightsAndIndex = new int[2][caRuleWeights.size()];
        for (int m = 0; m < caRuleWeights.size(); ++m) {
            this.caRulesWeightsAndIndex[0][m] = caRuleWeights.get(m);
            this.caRulesWeightsAndIndex[1][m] = m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeGlobalOptions(PrintWriter pw) {
        int m;
        ArrayList<Integer> caRuleWeights = new ArrayList<Integer>();
        this.printGlobalOptions(pw, true);
        pw.println();
        pw.println("<-MinHeight and MaxHeight are the minimum and maximum allowed height of the structures->");
        pw.println("<-MinHeightBeforeOscillation - Any structures that form oscillators before MaxOscillatorCullStep will be culled.->");
        pw.println("<-Smooth with stairs - If set to true, will smooth out ruins by placing extra stair blocks.->");
        pw.println("<-ContainerWidth and ContainerLength are the dimensions of the bounding rectangle.->");
        pw.println("MinHeight:" + this.MinHeight);
        pw.println("MaxHeight:" + this.MaxHeight);
        pw.println("MinHeightBeforeOscillation:" + this.MinHeightBeforeOscillation);
        pw.println("SmoothWithStairs:" + this.SmoothWithStairs);
        pw.println("MakeFloors:" + this.MakeFloors);
        pw.println("ContainerWidth:" + this.ContainerWidth);
        pw.println("ContainerLength:" + this.ContainerLength);
        pw.println();
        this.printDefaultChestItems(pw);
        pw.println();
        pw.println("<-Seed type weights are the relative likelihood weights that different seeds will be used. Weights are nonnegative integers.->");
        pw.println("<-SymmetricSeedDensity is the density (out of 1.0) of live blocks in the symmetric seed.->");
        pw.println("SymmetricSeedDensity:" + this.SymmetricSeedDensity);
        for (m = 0; m < SEED_TYPE_STRINGS.length; ++m) {
            pw.println(SEED_TYPE_STRINGS[m] + ":" + this.seedTypeWeights[m]);
        }
        pw.println();
        pw.println("<-These spawner rule variables control what spawners will be used depending on the light level and floor width.->");
        for (m = 0; m < this.spawnerRules.length; ++m) {
            pw.println(SPAWNER_RULE_NAMES[m] + ":" + this.spawnerRules[m]);
        }
        pw.println();
        pw.println("<-BlockRule is the template rule that controls what blocks the structure will be made out of.->");
        pw.println("<-Default is BiomeNameBlockRule:" + DEFAULT_TEMPLATE.toString() + "->");
        pw.println("<-Which translates into: (special condition) then,(100%=complete)ruin in either normal(1 out of 3 chance) or mossy cobblestone(2 out of 3) in said biome->");
        pw.println("<-Metadatas are supported, use blockname-blockmetadata syntax->");
        for (m = 0; m < DEFAULT_BLOCK_RULES.length; ++m) {
            if (BLOCK_RULE_NAMES[m] == null) continue;
            pw.println(BLOCK_RULE_NAMES[m] + ":" + DEFAULT_BLOCK_RULES[m]);
        }
        pw.println();
        pw.println("<-An automata rule should be in the form B<neighbor digits>/S<neighbor digits>, where B stands for \"birth\" and S stands->");
        pw.println("<-   for \"survive\". <neighbor digits> are the subset the digits from 0 to 8 on which the rule will birth or survive.->");
        pw.println("<-   For example, the Game of Life has the rule code B3/S23.->");
        pw.println("<-Rule weights are the relative likelihood weights that different rules will be used. Weights are nonnegative integers.->");
        pw.println(AUTOMATA_RULES_STRING);
        try {
            for (String[] defaultRule : DEFAULT_CA_RULES) {
                pw.println(defaultRule[0] + ", weight=" + defaultRule[1] + (defaultRule[2].length() > 0 ? ",  <-" + defaultRule[2] + "->" : ""));
                this.caRules.add(BuildingCellularAutomaton.parseCARule(defaultRule[0], this.lw));
                caRuleWeights.add(Integer.parseInt(defaultRule[1]));
            }
        }
        catch (NumberFormatException e) {
            this.lw.println(e.getMessage());
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        this.setRulesWeightAndIndex(caRuleWeights);
    }

    @Override
    public final void generate(World world, Random random, int i, int k) {
        if (random.nextFloat() < this.GlobalFrequency) {
            new WorldGenCARuins(this, world, random, i, k, this.TriesPerChunk, (double)this.GlobalFrequency).run();
        }
    }

    public String toString() {
        return "CARuins";
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        if (!this.dataFilesLoaded) {
            this.loadDataFiles();
        }
        if (!this.errFlag) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)2);
        }
    }

    static {
        DEFAULT_TEMPLATE = new TemplateRule(new Block[]{Blocks.field_150347_e, Blocks.field_150341_Y, Blocks.field_150341_Y}, new int[]{0, 0, 0}, 100);
        DEFAULT_BLOCK_RULES = new TemplateRule[BIOME_NAMES.length];
        PopulatorCARuins.DEFAULT_BLOCK_RULES[0] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[1] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[2] = new TemplateRule(new Block[]{Blocks.field_150348_b, Blocks.field_150417_aV, Blocks.field_150417_aV}, new int[]{0, 1, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[3] = new TemplateRule(Blocks.field_150322_A, 0, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[4] = new TemplateRule(new Block[]{Blocks.field_150348_b, Blocks.field_150417_aV, Blocks.field_150417_aV}, new int[]{0, 0, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[5] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[6] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[7] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[8] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[9] = new TemplateRule(Blocks.field_150385_bj, 0, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[10] = new TemplateRule(Blocks.field_150377_bs, 0, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[11] = new TemplateRule(new Block[]{Blocks.field_150432_aD, Blocks.field_150433_aE, Blocks.field_150417_aV}, new int[]{0, 0, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[12] = new TemplateRule(new Block[]{Blocks.field_150432_aD, Blocks.field_150433_aE, Blocks.field_150417_aV}, new int[]{0, 0, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[13] = new TemplateRule(new Block[]{Blocks.field_150433_aE, Blocks.field_150417_aV, Blocks.field_150417_aV}, new int[]{0, 2, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[14] = new TemplateRule(new Block[]{Blocks.field_150433_aE, Blocks.field_150417_aV, Blocks.field_150417_aV}, new int[]{0, 2, 2}, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[15] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[16] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[17] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[18] = new TemplateRule(Blocks.field_150322_A, 0, 100);
        PopulatorCARuins.DEFAULT_BLOCK_RULES[19] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[20] = DEFAULT_TEMPLATE;
        PopulatorCARuins.DEFAULT_BLOCK_RULES[21] = new TemplateRule(new Block[]{Blocks.field_150348_b, Blocks.field_150417_aV, Blocks.field_150417_aV}, new int[]{0, 0, 2}, 100);
        BLOCK_RULE_NAMES = new String[DEFAULT_BLOCK_RULES.length];
        SPAWNER_RULE_NAMES = new String[]{"MediumLightNarrowFloorSpawnerRule", "MediumLightWideFloorSpawnerRule", "LowLightSpawnerRule"};
        DEFAULT_CA_RULES = new String[][]{{"B3/S23", "5", "Life - good for weird temples"}, {"B36/S013468", "3", "pillars and hands"}, {"B367/S02347", "2", "towers with interiors and chasms"}, {"B34/S2356", "3", "towers with hetrogenous shapes"}, {"B368/S245", "8", "Morley - good hanging bits"}, {"B36/S125", "4", "2x2 - pillar & arch temple/tower/statue"}, {"B36/S23", "4", "High Life - space invaders, hanging arms."}, {"B3568/S148", "4", "fuzzy stilts"}, {"B3/S1245", "8", "complex"}, {"B3567/S13468", "5", "fat fuzzy"}, {"B356/S16", "5", "fuzzy with spurs"}, {"B3468/S123", "3", "towers with arches"}, {"B35678/S015678", "2", "checkerboard"}, {"B35678/S0156", "15", "spermatazoa"}, {"B26/S12368", "1", "mayan pyramid"}, {"B248/S45", "1", "gaudi pyramid"}, {"B2457/S013458", "1", "complex interior pyramid"}, {"B45/S2345", "6", "45-rule - square towers"}};
        SEED_TYPE_STRINGS = new String[]{"SymmetricSeedWeight", "LinearSeedWeight", "CircularSeedWeight", "CruciformSeedWeight"};
    }
}

