/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.Building;
import assets.generator.BuildingExplorationHandler;
import assets.generator.TemplateWall;
import assets.generator.WorldGenUndergroundCity;
import assets.generator.WorldGenWalledCity;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;

@Mod(modid="WalledCityMod", name="Walled City Generator", version="0.1.6", dependencies="after:ExtraBiomes,BiomesOPlenty", acceptableRemoteVersions="*")
public class PopulatorWalledCity
extends BuildingExplorationHandler {
    @Mod.Instance(value="WalledCityMod")
    public static PopulatorWalledCity instance;
    public static final int MIN_CITY_LENGTH = 40;
    static final int MAX_FOG_HEIGHT = 27;
    public static final int CITY_TYPE_UNDERGROUND = 1;
    private static final String CITY_FILE_SAVE = "WalledCities.txt";
    private static final String STREET_TEMPLATES_FOLDER_NAME = "streets";
    public float UndergroundGlobalFrequency = 0.015f;
    public int MinCitySeparation = 500;
    public int UndergroundMinCitySeparation = 500;
    public boolean CityBuiltMessage = false;
    public int BacktrackLength = 9;
    public boolean RejectOnPreexistingArtifacts = true;
    public List<TemplateWall> cityStyles = null;
    public List<TemplateWall> undergroundCityStyles = new ArrayList<TemplateWall>();
    public Map<World, List<int[]>> cityLocations;
    public Map<Integer, List<VillageDoorInfo>> cityDoors;
    public LinkedList<int[]> citiesBuiltMessages = new LinkedList();
    private Map<World, File> cityFiles;

    public void addCityToVillages(World world, int id) {
        if (world != null && world.field_73011_w.field_76574_g != 1 && world.field_72982_D != null) {
            Village city = new Village(world);
            if (this.cityDoors.containsKey(id)) {
                for (VillageDoorInfo door : this.cityDoors.get(id)) {
                    if (door == null) continue;
                    city.func_75576_a(door);
                }
                world.field_72982_D.func_75540_b().add(city);
                this.cityDoors.remove(id);
            }
        }
    }

    public void chatBuildingCity(String chatString, String logString) {
        if (logString != null) {
            this.logOrPrint(logString, "FINEST");
        }
        if (!this.CityBuiltMessage) {
            return;
        }
        List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        if (playerList != null) {
            for (int index = 0; index < playerList.size(); ++index) {
                EntityPlayerMP player = (EntityPlayerMP)playerList.get(index);
                player.func_146105_b((IChatComponent)new ChatComponentText(chatString));
            }
        }
    }

    public void chatCityBuilt(int[] args) {
        if (!this.CityBuiltMessage) {
            return;
        }
        List playerList = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        if (playerList == null) {
            this.citiesBuiltMessages.add(args);
        } else {
            for (int index = 0; index < playerList.size(); ++index) {
                EntityPlayerMP player = (EntityPlayerMP)playerList.get(index);
                int dI = args[0] - (int)player.field_70165_t;
                int dK = args[2] - (int)player.field_70161_v;
                if (dI * dI + dK * dK < args[4] * args[4]) {
                    String string = "nearby";
                }
                String dirStr = "to the ";
                dirStr = Math.abs(dI) > 2 * Math.abs(dK) ? dirStr + (dI > 0 ? "east" : "west") : (Math.abs(dK) > 2 * Math.abs(dI) ? dirStr + (dK > 0 ? "south" : "north") : dirStr + (dI > 0 ? (dK > 0 ? "southeast" : "northeast") : (dK > 0 ? "southwest" : "northwest")));
                player.func_146105_b((IChatComponent)new ChatComponentText("** Built city " + dirStr + " (" + args[0] + "," + args[1] + "," + args[2] + ")! **"));
            }
        }
    }

    public boolean cityIsSeparated(World world, int i, int k, int cityType) {
        if (this.cityLocations.containsKey(world)) {
            for (int[] location : this.cityLocations.get(world)) {
                if (location[2] != cityType || Math.abs(location[0] - i) + Math.abs(location[1] - k) >= (cityType == 1 ? this.UndergroundMinCitySeparation : this.MinCitySeparation)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void generate(World world, Random random, int i, int k) {
        if (this.CityBuiltMessage && world.field_73010_i != null) {
            while (this.citiesBuiltMessages.size() > 0) {
                this.chatCityBuilt(this.citiesBuiltMessages.remove());
            }
        }
        if (this.cityStyles.size() > 0 && this.cityIsSeparated(world, i, k, world.field_73011_w.field_76574_g) && random.nextFloat() < this.GlobalFrequency) {
            new WorldGenWalledCity(this, world, random, i, k, this.TriesPerChunk, (double)this.GlobalFrequency).run();
        }
        if (this.undergroundCityStyles.size() > 0 && this.cityIsSeparated(world, i, k, 1) && random.nextFloat() < this.UndergroundGlobalFrequency) {
            WorldGenUndergroundCity wgt = new WorldGenUndergroundCity(this, world, random, i, k, 1, (double)this.UndergroundGlobalFrequency);
            int minSpawnHeight = 34;
            int maxSpawnHeight = Building.findSurfaceJ(world, i, k, 255, false, -1) - 15 - 5;
            if (minSpawnHeight <= maxSpawnHeight) {
                wgt.setSpawnHeight(minSpawnHeight, maxSpawnHeight, false);
            }
            wgt.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataFiles() {
        try {
            this.initializeLogging("Loading options and templates for the Walled City Generator.");
            this.getGlobalOptions();
            File stylesDirectory = new File(CONFIG_DIRECTORY, this.templateFolderName);
            this.cityStyles = TemplateWall.loadWallStylesFromDir(stylesDirectory, this);
            TemplateWall.loadStreets(this.cityStyles, new File(stylesDirectory, STREET_TEMPLATES_FOLDER_NAME), this);
            for (int m = 0; m < this.cityStyles.size(); ++m) {
                if (!this.cityStyles.get((int)m).underground) continue;
                TemplateWall uws = this.cityStyles.remove(m);
                uws.streets.add(uws);
                this.undergroundCityStyles.add(uws);
                --m;
            }
            this.finalizeLoading(true, "city");
        }
        catch (Exception e) {
            this.errFlag = true;
            this.lw.println("There was a problem loading the walled city mod: " + e.getMessage());
            this.logOrPrint("There was a problem loading the walled city mod: " + e.getMessage(), "SEVERE");
            e.printStackTrace();
        }
        finally {
            if (this.lw != null) {
                this.lw.close();
            }
        }
        if ((double)this.GlobalFrequency < 1.0E-6 && (double)this.UndergroundGlobalFrequency < 1.0E-6) {
            this.errFlag = true;
        }
        this.dataFilesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadGlobalOptions(BufferedReader br) {
        try {
            String read = br.readLine();
            while (read != null) {
                this.readGlobalOptions(this.lw, read);
                if (read.startsWith("UndergroundGlobalFrequency")) {
                    this.UndergroundGlobalFrequency = PopulatorWalledCity.readFloatParam(this.lw, this.UndergroundGlobalFrequency, ":", read);
                }
                if (read.startsWith("MinCitySeparation")) {
                    this.MinCitySeparation = PopulatorWalledCity.readIntParam(this.lw, this.MinCitySeparation, ":", read);
                }
                if (read.startsWith("MinUndergroundCitySeparation")) {
                    this.UndergroundMinCitySeparation = PopulatorWalledCity.readIntParam(this.lw, this.UndergroundMinCitySeparation, ":", read);
                }
                if (read.startsWith("BacktrackLength")) {
                    this.BacktrackLength = PopulatorWalledCity.readIntParam(this.lw, this.BacktrackLength, ":", read);
                }
                if (read.startsWith("CityBuiltMessage")) {
                    this.CityBuiltMessage = PopulatorWalledCity.readBooleanParam(this.lw, this.CityBuiltMessage, ":", read);
                }
                if (read.startsWith("RejectOnPreexistingArtifacts")) {
                    this.RejectOnPreexistingArtifacts = PopulatorWalledCity.readBooleanParam(this.lw, this.RejectOnPreexistingArtifacts, ":", read);
                }
                this.readChestItemsList(this.lw, read, br);
                read = br.readLine();
            }
            if (this.TriesPerChunk > 100) {
                this.TriesPerChunk = 100;
            }
        }
        catch (IOException e) {
            this.lw.println(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent event) {
        if (!this.dataFilesLoaded) {
            this.loadDataFiles();
        }
        if (!this.errFlag) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.cityFiles = new HashMap<World, File>();
        this.cityLocations = new HashMap<World, List<int[]>>();
        this.cityDoors = new HashMap<Integer, List<VillageDoorInfo>>();
        this.logger = event.getModLog();
        this.settingsFileName = "WalledCitySettings.txt";
        this.templateFolderName = "walledcity";
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/GotoLink/Generatormods/master/update.xml", "https://raw.github.com/GotoLink/Generatormods/master/changelog.md");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCityLocations(World world) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(this.cityFiles.get(world), true)));
            BufferedReader br = new BufferedReader(new FileReader(this.cityFiles.get(world)));
            if (br.readLine() == null) {
                pw.println("City locations in " + world.field_73011_w.func_80007_l() + " of : " + world.func_72912_H().func_76065_j());
            }
            br.close();
            int[] location = this.cityLocations.get(world).get(this.cityLocations.get(world).size() - 1);
            pw.println(new StringBuilder(Integer.toString(location[0])).append(",").append(Integer.toString(location[1])).append(",").append(Integer.toString(location[2])));
        }
        catch (IOException e) {
            this.logOrPrint(e.getMessage(), "WARNING");
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public String toString() {
        return "WalledCityMod";
    }

    @Override
    public void updateWorldExplored(World world) {
        super.updateWorldExplored(world);
        File cityFile = new File(PopulatorWalledCity.getWorldSaveDir(world), world.field_73011_w.func_80007_l() + CITY_FILE_SAVE);
        if (this.cityFiles.isEmpty() || !this.cityFiles.containsKey(world)) {
            this.cityFiles.put(world, cityFile);
        }
        try {
            if (!cityFile.createNewFile() && !this.cityLocations.containsKey(world)) {
                this.cityLocations.put(world, PopulatorWalledCity.getCityLocs(cityFile));
            }
        }
        catch (IOException e) {
            this.logOrPrint(e.getMessage(), "WARNING");
        }
    }

    @Override
    public void writeGlobalOptions(PrintWriter pw) {
        this.printGlobalOptions(pw, false);
        pw.println("<-GlobalFrequency/UndergroundGlobalFrequency controls how likely aboveground/belowground cities are to appear. Should be between 0.0 and 1.0. Lower to make less common->");
        pw.println("GlobalFrequency:" + this.GlobalFrequency);
        pw.println("UndergroundGlobalFrequency:" + this.UndergroundGlobalFrequency);
        pw.println("<-MinCitySeparation/UndergroundMinCitySeparation define a minimum allowable separation between city spawns.->");
        pw.println("MinCitySeparation:" + this.MinCitySeparation);
        pw.println("MinUndergroundCitySeparation:" + this.UndergroundMinCitySeparation);
        pw.println();
        pw.println("<-BacktrackLength - length of backtracking for wall planning if a dead end is hit->");
        pw.println("BacktrackLength:" + this.BacktrackLength);
        pw.println("<-CityBuiltMessage controls whether players receive message when a city is building. Set to true to receive message.->");
        pw.println("CityBuiltMessage:" + this.CityBuiltMessage);
        pw.println("<-RejectOnPreexistingArtifacts determines whether the planner rejects city sites that contain preexiting man-made blocks. Set to true to do this check.->");
        pw.println("RejectOnPreexistingArtifacts:" + this.RejectOnPreexistingArtifacts);
        pw.println();
        this.printDefaultChestItems(pw);
        if (pw != null) {
            pw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<int[]> getCityLocs(File city) {
        ArrayList<int[]> cityLocs = new ArrayList<int[]>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(city));
            String read = br.readLine();
            while (read != null) {
                String[] split = read.split(",");
                if (split.length == 3) {
                    cityLocs.add(new int[]{Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2])});
                }
                read = br.readLine();
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return cityLocs;
    }
}

