/*
 * Decompiled with CFR 0.152.
 */
package assets.generator;

import assets.generator.BlockProperties;
import assets.generator.Building;
import assets.generator.BuildingDoubleWall;
import assets.generator.BuildingTower;
import assets.generator.BuildingWall;
import assets.generator.PopulatorWalledCity;
import assets.generator.TemplateWall;
import assets.generator.WorldGeneratorThread;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenWalledCity
extends WorldGeneratorThread {
    private static final int GATE_HEIGHT = 6;
    private static final int JMEAN_DEVIATION_SLOPE = 10;
    private static final int LEVELLING_DEVIATION_SLOPE = 18;
    private static final int MIN_SIDE_LENGTH = 10;
    private static final float MAX_WATER_PERCENTAGE = 0.4f;
    private TemplateWall ows;
    private TemplateWall sws;
    private BuildingWall[] walls;
    private int axXHand;
    private int[] dir = null;
    private int Lmean;
    private int jmean;
    private final int cityType;
    private int[] corner1;
    private int[] corner2;
    private int[] mincorner;
    public int[][] layout;

    public WorldGenWalledCity(PopulatorWalledCity wc, World world, Random random, int chunkI, int chunkK, int triesPerChunk, double chunkTryProb) {
        super(wc, world, random, chunkI, chunkK, triesPerChunk, chunkTryProb);
        this.cityType = world.field_73011_w.field_76574_g;
    }

    @Override
    public boolean generate(int i0, int j0, int k0) {
        this.ows = TemplateWall.pickBiomeWeightedWallStyle(((PopulatorWalledCity)this.master).cityStyles, this.world, i0, k0, this.world.field_73012_v, false);
        if (this.ows == null) {
            return false;
        }
        this.sws = TemplateWall.pickBiomeWeightedWallStyle(this.ows.streets, this.world, i0, k0, this.world.field_73012_v, false);
        if (this.sws == null) {
            return false;
        }
        if (!((PopulatorWalledCity)this.master).cityIsSeparated(this.world, i0, k0, this.cityType)) {
            return false;
        }
        int ID = (this.random.nextInt(9000) + 1000) * 100;
        int minJ = this.ows.LevelInterior ? 62 : -1;
        this.chooseDirection(i0 >> 4, k0 >> 4);
        if (this.ows.MinL < 40) {
            this.ows.MinL = 40;
        }
        this.walls = new BuildingWall[4];
        this.ows.setFixedRules(this.world.field_73012_v);
        this.walls[0] = new BuildingWall(ID, this, this.ows, this.dir[0], this.axXHand, this.ows.MinL + this.random.nextInt(this.ows.MaxL - this.ows.MinL), false, i0, j0, k0).setMinJ(minJ);
        this.walls[0].plan(1, 0, 5, true);
        if (this.walls[0].bLength < this.ows.MinL) {
            return false;
        }
        this.walls[0].setCursor(this.walls[0].bLength - 1);
        this.walls[1] = new BuildingWall(ID + 1, (WorldGeneratorThread)this, this.ows, this.dir[1], this.axXHand, this.ows.MinL + this.random.nextInt(this.ows.MaxL - this.ows.MinL), false, this.walls[0].getIJKPt(-1 - this.ows.TowerXOffset, 0, 1 + this.ows.TowerXOffset)).setTowers(this.walls[0]).setMinJ(minJ);
        if (!((PopulatorWalledCity)this.master).cityIsSeparated(this.world, this.walls[1].i1, this.walls[1].k1, this.cityType)) {
            return false;
        }
        this.walls[1].plan(1, 0, 5, false);
        if (this.walls[1].bLength < this.ows.MinL) {
            return false;
        }
        this.walls[1].setCursor(this.walls[1].bLength - 1);
        int distToTarget = this.walls[0].bLength + this.walls[1].xArray[this.walls[1].bLength - 1];
        if (distToTarget < 10) {
            return false;
        }
        this.walls[2] = new BuildingWall(ID + 2, (WorldGeneratorThread)this, this.ows, this.dir[2], this.axXHand, distToTarget + 2, false, this.walls[1].getIJKPt(-1 - this.ows.TowerXOffset, 0, 1 + this.ows.TowerXOffset)).setTowers(this.walls[0]).setMinJ(minJ);
        if (!((PopulatorWalledCity)this.master).cityIsSeparated(this.world, this.walls[2].i1, this.walls[2].k1, this.cityType)) {
            return false;
        }
        this.walls[2].setCursor(0);
        this.walls[2].setTarget(this.walls[2].getIJKPt(0, 0, distToTarget));
        this.walls[2].plan(1, 0, 5, false);
        if (this.walls[2].bLength < this.walls[2].y_targ) {
            return false;
        }
        this.walls[2].setCursor(this.walls[2].bLength - 1);
        distToTarget = this.walls[1].bLength - this.walls[0].xArray[this.walls[0].bLength - 1] + this.walls[1].xArray[this.walls[1].bLength - 1];
        if (distToTarget < 10) {
            return false;
        }
        this.walls[3] = new BuildingWall(ID + 3, (WorldGeneratorThread)this, this.ows, this.dir[3], this.axXHand, distToTarget + 2, false, this.walls[2].getIJKPt(-1 - this.ows.TowerXOffset, 0, 1 + this.ows.TowerXOffset)).setTowers(this.walls[0]).setMinJ(minJ);
        if (!((PopulatorWalledCity)this.master).cityIsSeparated(this.world, this.walls[3].i1, this.walls[3].k1, this.cityType)) {
            return false;
        }
        this.walls[0].setCursor(0);
        this.walls[3].setCursor(0);
        this.walls[3].setTarget(this.walls[0].getIJKPt(-1 - this.ows.TowerXOffset, 0, -1 - this.ows.TowerXOffset));
        this.walls[3].plan(1, 0, 5, false);
        if (this.walls[3].bLength < this.walls[3].y_targ) {
            return false;
        }
        for (BuildingWall w : this.walls) {
            w.smooth(this.ows.ConcaveDownSmoothingScale, this.ows.ConcaveUpSmoothingScale, true);
        }
        int[] xmax = new int[4];
        for (int w = 0; w < 4; ++w) {
            xmax[w] = 0;
            for (int n = 0; n < this.walls[w].bLength; ++n) {
                if (this.walls[w].xArray[n] <= xmax[w]) continue;
                xmax[w] = this.walls[w].xArray[n];
            }
        }
        for (BuildingWall w : this.walls) {
            w.setCursor(0);
        }
        this.corner1 = this.walls[1].getIJKPt(xmax[1] + this.walls[1].bWidth + 1, 0, this.walls[0].xArray[this.walls[0].bLength - 1] - xmax[0] - this.walls[0].bWidth - 2);
        this.corner2 = this.walls[3].getIJKPt(xmax[3] + this.walls[3].bWidth + 1, 0, this.walls[2].xArray[this.walls[2].bLength - 1] - xmax[2] - this.walls[2].bWidth - 2);
        this.mincorner = new int[]{Math.min(this.corner1[0], this.corner2[0]), 0, Math.min(this.corner1[2], this.corner2[2])};
        this.Lmean = (this.walls[0].bLength + this.walls[1].bLength + this.walls[2].bLength + this.walls[3].bLength) / 4;
        this.jmean = 0;
        for (BuildingWall w : this.walls) {
            for (int n = 0; n < w.bLength; ++n) {
                this.jmean += w.zArray[n] + w.j1;
            }
        }
        this.jmean /= this.Lmean * 4;
        for (BuildingWall w : this.walls) {
            if (Math.abs(w.j1 - this.jmean) <= w.bLength / 10) continue;
            this.master.logOrPrint("Rejected city " + ID + ", height at corner differed from mean by " + Math.abs(w.j1 - this.jmean) + ".", "INFO");
            return false;
        }
        int cityArea = 0;
        int waterArea = 0;
        int incI = Building.signum(this.corner2[0] - this.corner1[0], 0);
        int incK = Building.signum(this.corner2[2] - this.corner1[2], 0);
        int i2 = this.corner1[0];
        while ((this.corner2[0] - i2) * incI > 0) {
            int k2 = this.corner1[2];
            while ((this.corner2[2] - k2) * incK > 0) {
                boolean enclosed = true;
                for (BuildingWall w : this.walls) {
                    if (!w.ptIsToXHand(new int[]{i2, 0, k2}, 1)) continue;
                    enclosed = false;
                }
                if (enclosed) {
                    int j2 = Building.findSurfaceJ(this.world, i2, k2, 255, true, 3);
                    ++cityArea;
                    if (j2 == -666) {
                        ++waterArea;
                    }
                    if (((PopulatorWalledCity)this.master).RejectOnPreexistingArtifacts && this.ows.LevelInterior && BlockProperties.get((Block)this.world.func_147439_a((int)i2, (int)j2, (int)k2)).isArtificial) {
                        this.master.logOrPrint("Rejected " + this.ows.name + " city " + ID + ", found previous construction in city zone!", "WARNING");
                        return false;
                    }
                }
                k2 += incK;
            }
            i2 += incI;
        }
        if (!this.ows.LevelInterior && (float)waterArea / (float)cityArea > 0.4f) {
            this.master.logOrPrint("Rejected " + this.ows.name + " city " + ID + ", too much water! City area was " + 100.0f * (float)waterArea / (float)cityArea + "% water!", "INFO");
            return false;
        }
        for (BuildingWall w : this.walls) {
            if (((PopulatorWalledCity)this.master).cityIsSeparated(this.world, w.i1, w.k1, this.cityType)) continue;
            this.master.logOrPrint("Rejected city " + ID + " nearby city was built during planning!", "WARNING");
            return false;
        }
        this.walls[0].setCursor(0);
        int[] cityCenter = new int[]{(this.walls[0].i1 + this.walls[1].i1 + this.walls[2].i1 + this.walls[3].i1) / 4, 0, (this.walls[0].k1 + this.walls[1].k1 + this.walls[2].k1 + this.walls[3].k1) / 4};
        cityCenter[1] = Building.findSurfaceJ(this.world, cityCenter[0], cityCenter[1], 255, false, 3);
        ((PopulatorWalledCity)this.master).cityLocations.get(this.world).add(new int[]{cityCenter[0], cityCenter[2], this.cityType});
        ((PopulatorWalledCity)this.master).saveCityLocations(this.world);
        ((PopulatorWalledCity)this.master).chatBuildingCity("** Building city... **", "\n***** Building " + this.ows.name + " city" + ", ID=" + ID + " in " + this.world.getBiomeGenForCoordsBody((int)this.walls[0].i1, (int)this.walls[0].k1).field_76791_y + " biome between " + this.walls[0].localCoordString(0, 0, 0) + " and " + this.walls[2].localCoordString(0, 0, 0) + " ******\n");
        if (this.ows.LevelInterior) {
            this.levelCity();
        }
        TemplateWall avenueWS = TemplateWall.pickBiomeWeightedWallStyle(this.ows.streets, this.world, i0, k0, this.world.field_73012_v, false);
        LinkedList<BuildingWall> radialAvenues = new LinkedList<BuildingWall>();
        this.layout = new int[Math.abs(this.corner1[0] - this.corner2[0])][Math.abs(this.corner1[2] - this.corner2[2])];
        for (int x = 0; x < this.layout.length; ++x) {
            for (int y = 0; y < this.layout[0].length; ++y) {
                this.layout[x][y] = 0;
            }
        }
        for (BuildingWall w : this.walls) {
            w.setLayoutCode(1);
        }
        int gateFlankingTowers = 0;
        for (BuildingWall w : this.walls) {
            w.endBLength = 0;
            w.buildFromTML();
            int radialAvenueHand = w.bDir == this.dir[0] || w.bDir == this.dir[1] ? -1 : 1;
            int startScan = w.getY(cityCenter) + (radialAvenueHand == w.bHand ? avenueWS.WWidth - 1 : 0);
            BuildingWall[] avenues = w.buildGateway(new int[]{w.bLength / 4, 3 * w.bLength / 4}, startScan, 6, avenueWS.WWidth, avenueWS, this.random.nextInt(6) < gateFlankingTowers ? 0 : this.axXHand, 500, null, -this.axXHand, 150, cityCenter, radialAvenueHand);
            w.makeBuildings(this.axXHand == -1, this.axXHand == 1, true, false, false);
            if (w.gatewayStart != -1) {
                ++gateFlankingTowers;
            }
            if (avenues != null) {
                avenues[0].buildFromTML();
                radialAvenues.add(avenues[1]);
                continue;
            }
            w.setCursor(startScan);
            BuildingWall radialAvenue = new BuildingWall(0, (WorldGeneratorThread)this, this.sws, Building.rotDir(w.bDir, -this.axXHand), radialAvenueHand, this.ows.MaxL, false, w.getSurfaceIJKPt(-1, 0, 255, false, -1));
            radialAvenue.setTarget(cityCenter);
            radialAvenue.plan(1, 0, 5, true);
            if (radialAvenue.bLength <= 20) continue;
            radialAvenue.smooth(10, 10, true);
            radialAvenues.add(radialAvenue);
        }
        for (BuildingWall w : this.walls) {
            w.setCursor(0);
        }
        if (this.ows.MakeEndTowers) {
            for (int w = 0; w < 4; ++w) {
                if (this.walls[(w + 3) % 4].bLength <= 2) continue;
                int zmean = (this.walls[w].zArray[2] - this.walls[w].j1 + this.walls[(w + 3) % 4].zArray[this.walls[(w + 3) % 4].bLength - 3] + this.walls[(w + 3) % 4].j1) / 2;
                int minCornerWidth = this.ows.WWidth + 2 + (this.ows.TowerXOffset < 0 ? 2 * this.ows.TowerXOffset : 0);
                int TWidth = this.ows.getTMaxWidth(this.walls[w].circular) < minCornerWidth ? minCornerWidth : this.ows.getTMaxWidth(this.walls[w].circular);
                BuildingTower tower = new BuildingTower(ID + 10 + w, this.walls[w], this.dir[(w + 2) % 4], -this.axXHand, false, TWidth, this.ows.getTMaxHeight(this.walls[w].circular), TWidth, this.walls[w].getIJKPt(-2 - (this.ows.TowerXOffset < 0 ? this.ows.TowerXOffset : 0), zmean, 2));
                this.setLayoutCode(tower.getIJKPt(0, 0, 0), tower.getIJKPt(TWidth - 1, 0, TWidth - 1), 4);
                tower.build(0, 0, true);
            }
        }
        boolean cityIsDense = this.ows.StreetDensity >= 15;
        LinkedList<BuildingDoubleWall> crossAvenues = new LinkedList<BuildingDoubleWall>();
        int avInterval = cityIsDense ? 60 : (this.Lmean > 110 ? 35 : 20);
        int maxStreetCount = this.Lmean * this.ows.StreetDensity / 20;
        for (BuildingWall radialAvenue : radialAvenues) {
            for (int n = radialAvenue.bLength - avInterval; n >= 20; n -= avInterval) {
                radialAvenue.setCursor(n);
                BuildingDoubleWall crossAvenue = new BuildingDoubleWall(ID, this, this.sws, Building.rotDir(radialAvenue.bDir, 1), 1, radialAvenue.getIJKPt(0, 0, 0));
                if (!crossAvenue.plan()) continue;
                crossAvenues.add(crossAvenue);
            }
            radialAvenue.setLayoutCode(2);
        }
        for (BuildingWall avenue : radialAvenues) {
            avenue.buildFromTML();
        }
        LinkedList<BuildingDoubleWall> plannedStreets = new LinkedList<BuildingDoubleWall>();
        for (int tries = 0; tries < maxStreetCount; ++tries) {
            BuildingDoubleWall street;
            int[] pt = this.randInteriorPoint();
            if (pt == null) continue;
            pt[1] = pt[1] + 1;
            this.sws = TemplateWall.pickBiomeWeightedWallStyle(this.ows.streets, this.world, i0, k0, this.world.field_73012_v, true);
            if (pt[1] == -1 || !(street = new BuildingDoubleWall(ID + tries, this, this.sws, this.random.nextInt(4), 1, pt)).plan()) continue;
            plannedStreets.add(street);
        }
        for (BuildingDoubleWall avenue : crossAvenues) {
            avenue.build(2);
        }
        for (BuildingDoubleWall street : plannedStreets) {
            street.build(3);
        }
        for (BuildingWall avenue : radialAvenues) {
            avenue.makeBuildings(true, true, false, cityIsDense, true);
        }
        for (BuildingDoubleWall avenue : crossAvenues) {
            avenue.buildTowers(true, true, false, cityIsDense, true);
        }
        for (BuildingDoubleWall street : plannedStreets) {
            street.buildTowers(true, true, this.sws.MakeGatehouseTowers, cityIsDense, false);
        }
        ((PopulatorWalledCity)this.master).chatCityBuilt(new int[]{i0, j0, k0, this.cityType, this.Lmean / 2 + 40});
        ((PopulatorWalledCity)this.master).addCityToVillages(this.world, ID);
        this.layout = null;
        this.walls = null;
        return true;
    }

    @Override
    public boolean isLayoutGenerator() {
        return true;
    }

    @Override
    public boolean layoutIsClear(Building building, boolean[][] templateLayout, int layoutCode) {
        for (int y = 0; y < templateLayout.length; ++y) {
            for (int x = 0; x < templateLayout[0].length; ++x) {
                if (!templateLayout[y][x]) continue;
                int i = building.getI(x, y);
                int k = building.getK(x, y);
                if (i < this.mincorner[0] || k < this.mincorner[2] || i - this.mincorner[0] >= this.layout.length || k - this.mincorner[2] >= this.layout[0].length || LAYOUT_CODE_OVERRIDE_MATRIX[this.layout[i - this.mincorner[0]][k - this.mincorner[2]]][layoutCode] != 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean layoutIsClear(int[] pt1, int[] pt2, int layoutCode) {
        for (int i = Math.min(pt1[0], pt2[0]); i <= Math.max(pt1[0], pt2[0]); ++i) {
            for (int k = Math.min(pt1[2], pt2[2]); k <= Math.max(pt1[2], pt2[2]); ++k) {
                if (i < this.mincorner[0] || k < this.mincorner[2] || i - this.mincorner[0] >= this.layout.length || k - this.mincorner[2] >= this.layout[0].length || LAYOUT_CODE_OVERRIDE_MATRIX[this.layout[i - this.mincorner[0]][k - this.mincorner[2]]][layoutCode] != 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setLayoutCode(Building building, boolean[][] templateLayout, int layoutCode) {
        for (int y = 0; y < templateLayout.length; ++y) {
            for (int x = 0; x < templateLayout[0].length; ++x) {
                if (!templateLayout[y][x]) continue;
                int i = building.getI(x, y);
                int k = building.getK(x, y);
                if (i < this.mincorner[0] || k < this.mincorner[2] || i - this.mincorner[0] >= this.layout.length || k - this.mincorner[2] >= this.layout[0].length) continue;
                this.layout[i - this.mincorner[0]][k - this.mincorner[2]] = layoutCode;
            }
        }
    }

    @Override
    public void setLayoutCode(int[] pt1, int[] pt2, int layoutCode) {
        for (int i = Math.min(pt1[0], pt2[0]); i <= Math.max(pt1[0], pt2[0]); ++i) {
            for (int k = Math.min(pt1[2], pt2[2]); k <= Math.max(pt1[2], pt2[2]); ++k) {
                if (i < this.mincorner[0] || k < this.mincorner[2] || i - this.mincorner[0] >= this.layout.length || k - this.mincorner[2] >= this.layout[0].length) continue;
                this.layout[i - this.mincorner[0]][k - this.mincorner[2]] = layoutCode;
            }
        }
    }

    private void chooseDirection(int chunkI, int chunkK) {
        boolean[] exploredChunk = new boolean[]{this.world.func_72899_e(chunkI << 4, 0, chunkK - 1 << 4), this.world.func_72899_e(chunkI + 1 << 4, 0, chunkK << 4), this.world.func_72899_e(chunkI << 4, 0, chunkK + 1 << 4), this.world.func_72899_e(chunkI - 1 << 4, 0, chunkK << 4)};
        this.dir = new int[4];
        int randDir = this.random.nextInt(4);
        this.dir[0] = (randDir + 1) % 4;
        while (this.dir[0] != randDir && !exploredChunk[this.dir[0]]) {
            this.dir[0] = (this.dir[0] + 1) % 4;
        }
        this.axXHand = exploredChunk[(this.dir[0] + 1) % 4] ? -1 : 1;
        this.dir[1] = (this.dir[0] - this.axXHand + 4) % 4;
        this.dir[2] = (this.dir[1] - this.axXHand + 4) % 4;
        this.dir[3] = (this.dir[2] - this.axXHand + 4) % 4;
    }

    private void levelCity() {
        for (BuildingWall w : this.walls) {
            w.setCursor(0);
        }
        int incI = Building.signum(this.corner2[0] - this.corner1[0], 0);
        int incK = Building.signum(this.corner2[2] - this.corner1[2], 0);
        int[] pt = new int[3];
        int jmin = this.world.field_73011_w.field_76575_d ? this.jmean : Math.max(this.jmean, 63);
        for (BuildingWall w : this.walls) {
            for (int n = 0; n < w.bLength; ++n) {
                if (w.zArray[n] + w.j1 + w.WalkHeight - 1 >= jmin || !this.world.field_73011_w.field_76575_d && jmin < 63) continue;
                jmin = w.zArray[n] + w.j1 + w.WalkHeight - 1;
            }
        }
        int jmax = Math.max(this.jmean + this.Lmean / 18, jmin);
        pt[0] = this.corner1[0];
        while ((this.corner2[0] - pt[0]) * incI > 0) {
            pt[2] = this.corner1[2];
            while ((this.corner2[2] - pt[2]) * incK > 0) {
                boolean enclosed = true;
                for (BuildingWall w : this.walls) {
                    if (!w.ptIsToXHand(pt, 1)) continue;
                    enclosed = false;
                }
                if (enclosed) {
                    pt[1] = Building.findSurfaceJ(this.world, pt[0], pt[2], 255, false, -1);
                    Block oldSurfaceBlockId = this.world.func_147439_a(pt[0], pt[1], pt[2]);
                    if (pt[1] > jmax) {
                        while (!this.world.func_147437_c(pt[0], pt[1] + 1, pt[2])) {
                            pt[1] = pt[1] + 1;
                        }
                        pt[1] = pt[1] + 10;
                        while (pt[1] > jmax) {
                            if (!this.world.func_147437_c(pt[0], pt[1], pt[2])) {
                                Building.setBlockAndMetaNoLighting(this.world, pt[0], pt[1], pt[2], Blocks.field_150350_a, 0);
                            }
                            pt[1] = pt[1] - 1;
                        }
                        if (!this.world.func_147437_c(pt[0], jmax - 1, pt[2])) {
                            Building.setBlockAndMetaNoLighting(this.world, pt[0], jmax, pt[2], oldSurfaceBlockId, 0);
                        }
                    }
                    if (pt[1] < jmin) {
                        Building.fillDown(pt, jmin, this.world);
                    }
                }
                pt[2] = pt[2] + incK;
            }
            pt[0] = pt[0] + incI;
        }
        int chunkI = this.corner1[0] >> 4;
        while (((this.corner2[0] >> 4) - chunkI) * incI > 0) {
            int chunkK = this.corner1[2] >> 4;
            while (((this.corner2[2] >> 4) - chunkK) * incK > 0) {
                this.world.func_72964_e(chunkI, chunkK).func_76603_b();
                chunkK += incK;
            }
            chunkI += incI;
        }
    }

    private void printLayout(File f) {
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            pw.println("  +y   ");
            pw.println("   ^   ");
            pw.println("+x<.>-x");
            pw.println("   v   ");
            pw.println("  -y   ");
            pw.println();
            for (int y = this.layout[0].length - 1; y >= 0; --y) {
                for (int x = this.layout.length - 1; x >= 0; --x) {
                    pw.print(LAYOUT_CODE_TO_CHAR[this.layout[x][y]]);
                }
                pw.println();
            }
            pw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int[] randInteriorPoint() {
        int[] pt = new int[3];
        this.master.logOrPrint("Finding random interior point for city seeded at corner (" + this.walls[0].i1 + "," + this.walls[0].j1 + "," + this.walls[0].k1 + ")" + this.walls[0].IDString(), "FINE");
        for (int tries = 0; tries < 20; ++tries) {
            pt[0] = this.mincorner[0] + this.random.nextInt(Math.abs(this.corner1[0] - this.corner2[0]));
            pt[2] = this.mincorner[2] + this.random.nextInt(Math.abs(this.corner1[2] - this.corner2[2]));
            pt[1] = Building.findSurfaceJ(this.world, pt[0], pt[2], 255, true, 3);
            boolean enclosed = true;
            for (BuildingWall w : this.walls) {
                if (!w.ptIsToXHand(pt, -this.sws.WWidth)) continue;
                enclosed = false;
            }
            if (!enclosed) continue;
            return pt;
        }
        this.master.logOrPrint("Could not find point within bounds!", "WARNING");
        return null;
    }
}

