/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.ForestryCore;
import forestry.core.config.ForestryItem;
import forestry.core.network.PacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FluidMap;
import forestry.core.utils.ItemStackMap;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

@Mod(modid="Forestry", name="Forestry", version="3.0.0.111", dependencies="required-after:Forge@[10.13.0.1207,);after:Buildcraft|Core;after:ExtrabiomesXL;after:BiomesOPlenty;after:IC2")
public class Forestry {
    @Mod.Instance(value="Forestry")
    public static Forestry instance;
    @SidedProxy(clientSide="forestry.core.ForestryClient", serverSide="forestry.core.ForestryCore")
    public static ForestryCore core;
    public static PacketHandler packetHandler;

    public Forestry() {
        FuelManager.fermenterFuel = new ItemStackMap<FermenterFuel>();
        FuelManager.moistenerResource = new ItemStackMap<MoistenerFuel>();
        FuelManager.rainSubstrate = new ItemStackMap<RainSubstrate>();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        packetHandler = new PacketHandler();
        core.preInit(event.getSourceFile(), this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        core.init(this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        core.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        core.serverStarting(event.getServer());
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        core.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Block block;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
                if (block == null) continue;
                mapping.remap(block);
                Proxies.log.warning("Remapping block " + mapping.name + " to " + StringUtil.cleanBlockName(block));
                continue;
            }
            block = GameRegistry.findBlock((String)"Forestry", (String)StringUtil.cleanTags(mapping.name));
            if (block != null) {
                mapping.remap(Item.func_150898_a((Block)block));
                Proxies.log.warning("Remapping item " + mapping.name + " to " + StringUtil.cleanBlockName(block));
                continue;
            }
            if (mapping.name.equals("Forestry:builderBackpack")) {
                mapping.remap(ForestryItem.builderBackpack.item());
                Proxies.log.warning("Remapping item " + mapping.name + " to " + ForestryItem.builderBackpack.name());
                continue;
            }
            if (mapping.name.equals("Forestry:builderBackpackT2")) {
                mapping.remap(ForestryItem.builderBackpackT2.item());
                Proxies.log.warning("Remapping item " + mapping.name + " to " + ForestryItem.builderBackpackT2.name());
                continue;
            }
            if (mapping.name.equals("Forestry:adventurerBackpack")) {
                mapping.remap(ForestryItem.adventurerBackpack.item());
                Proxies.log.warning("Remapping item " + mapping.name + " to " + ForestryItem.adventurerBackpack.name());
                continue;
            }
            if (mapping.name.equals("Forestry:adventurerBackpackT2")) {
                mapping.remap(ForestryItem.adventurerBackpackT2.item());
                Proxies.log.warning("Remapping item " + mapping.name + " to " + ForestryItem.adventurerBackpackT2.name());
                continue;
            }
            if (!mapping.name.equals("Forestry:shortMead")) continue;
            mapping.remap(ForestryItem.beverage.item());
            Proxies.log.warning("Remapping item " + mapping.name + " to " + ForestryItem.beverage.name());
        }
    }

    static {
        core = new ForestryCore();
    }
}

