/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.mail;

import com.mojang.authlib.GameProfile;
import forestry.api.core.INBTTagable;
import forestry.core.network.EntityNetData;
import forestry.core.proxy.Proxies;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class MailAddress
implements INBTTagable {
    @EntityNetData
    private String type;
    @EntityNetData
    private GameProfile gameProfile;
    private static final MailAddress invalidAddress = new MailAddress();

    public MailAddress() {
        this.type = "invalid";
        this.gameProfile = new GameProfile(new UUID(0L, 0L), "");
    }

    public MailAddress(GameProfile gameProfile) {
        if (gameProfile == null) {
            throw new IllegalArgumentException("gameProfile must not be null");
        }
        this.type = "player";
        this.gameProfile = gameProfile;
    }

    public MailAddress(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.type = "trader";
        this.gameProfile = new GameProfile(new UUID(0L, 0L), name);
    }

    public static MailAddress makeMailAddress(String name, String type) {
        if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        if ("player".equals(type)) {
            GameProfile gameProfile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(name);
            if (gameProfile == null) {
                gameProfile = new GameProfile(new UUID(0L, 0L), name);
            }
            return new MailAddress(gameProfile);
        }
        return new MailAddress(name);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.gameProfile.getName();
    }

    public String toString() {
        String name = this.getName().toLowerCase(Locale.ENGLISH);
        if (this.isPlayer()) {
            return this.type + "-" + name + "-" + this.gameProfile.getId();
        }
        return this.type + "-" + name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress address = (MailAddress)o;
        return address.gameProfile.equals((Object)this.gameProfile);
    }

    public int hashCode() {
        return this.gameProfile.hashCode();
    }

    public boolean isPlayer() {
        return "player".equals(this.type);
    }

    public boolean isValid() {
        return !"invalid".equals(this.type);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound.func_74764_b("TP")) {
            this.type = nbttagcompound.func_74779_i("TP");
        }
        if ("invalid".equals(this.type)) {
            this.gameProfile = MailAddress.invalidAddress.gameProfile;
        } else if (nbttagcompound.func_74764_b("profile")) {
            NBTTagCompound profileTag = nbttagcompound.func_74775_l("profile");
            this.gameProfile = NBTUtil.func_152459_a((NBTTagCompound)profileTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("TP", this.type);
        if (this.gameProfile != null) {
            NBTTagCompound profileNbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)profileNbt, (GameProfile)this.gameProfile);
            nbttagcompound.func_74782_a("profile", (NBTBase)profileNbt);
        }
    }

    public static MailAddress loadFromNBT(NBTTagCompound nbttagcompound) {
        MailAddress address = new MailAddress();
        address.readFromNBT(nbttagcompound);
        return address;
    }

    public EntityPlayer getPlayer(World world) {
        if (!this.isPlayer()) {
            return null;
        }
        return world.func_72924_a(this.gameProfile.getName());
    }

    public boolean isClientPlayer(World world) {
        if (!this.isPlayer()) {
            return false;
        }
        EntityPlayer addressPlayer = this.getPlayer(world);
        EntityPlayer clientPlayer = Proxies.common.getPlayer();
        return addressPlayer != null && clientPlayer != null && clientPlayer.equals((Object)addressPlayer);
    }
}

