/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CommandBeekeepingMode
extends CommandMC {
    String[] modeStrings = new String[PluginApiculture.beeInterface.getBeekeepingModes().size()];

    public CommandBeekeepingMode() {
        for (int i = 0; i < PluginApiculture.beeInterface.getBeekeepingModes().size(); ++i) {
            this.modeStrings[i] = PluginApiculture.beeInterface.getBeekeepingModes().get(i).getName();
        }
    }

    public int compareTo(Object arg0) {
        return this.func_71517_b().compareTo(((ICommand)arg0).func_71517_b());
    }

    public String func_71517_b() {
        return "beekeeping";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " help";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException(StringUtil.localizeAndFormat("chat.help", this.func_71518_a(sender)), new Object[0]);
        }
        if (arguments[0].matches("list")) {
            this.listModes(sender, arguments);
        } else if (arguments[0].matches("info")) {
            this.listModeInfo(sender, arguments);
        } else if (arguments[0].matches("set")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " set [<world-#>] <mode-name>", new Object[0]);
            }
            World world = this.getWorld(sender, arguments);
            String desired = arguments[arguments.length - 1];
            IBeekeepingMode mode = PluginApiculture.beeInterface.getBeekeepingMode(desired);
            if (mode == null) {
                throw new CommandException(StringUtil.localize("chat.bees.command.beekeeping.error"), new Object[]{desired});
            }
            PluginApiculture.beeInterface.setBeekeepingMode(world, mode.getName());
            CommandBeekeepingMode.func_152373_a((ICommandSender)sender, (ICommand)this, (String)StringUtil.localize("chat.bees.command.beekeeping.set"), (Object[])new Object[]{mode.getName()});
        } else if (arguments[0].matches("save")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " save <player-name>", new Object[0]);
            }
            this.saveStatistics(sender, arguments);
        } else if (arguments[0].matches("help")) {
            this.sendChatMessage(sender, StringUtil.localizeAndFormat("chat.bees.command.help.0", this.func_71517_b()));
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.help.1"));
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.help.2"));
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.help.3"));
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.help.4"));
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.help.5"));
        }
    }

    private void saveStatistics(ICommandSender sender, String[] arguments) {
        String newLine = System.getProperty("line.separator");
        World world = this.getWorld(sender, arguments);
        String player = arguments[1];
        ArrayList<String> statistics = new ArrayList<String>();
        statistics.add(String.format("Beekeeping statistics for %s on %s:", player, DateFormat.getInstance().format(new Date())));
        statistics.add("");
        statistics.add("MODE: " + PluginApiculture.beeInterface.getBeekeepingMode(world).getName());
        statistics.add("");
        GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(player);
        IApiaristTracker tracker = PluginApiculture.beeInterface.getBreedingTracker(world, profile);
        if (tracker == null) {
            statistics.add("No statistics found.");
        } else {
            statistics.add("BRED:");
            statistics.add("-----");
            statistics.add("");
            statistics.add("Queens:\t\t" + tracker.getQueenCount());
            statistics.add("Princesses:\t" + tracker.getPrincessCount());
            statistics.add("Drones:\t\t" + tracker.getDroneCount());
            statistics.add("");
            ArrayList<IAlleleBeeSpecies> species = new ArrayList<IAlleleBeeSpecies>();
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(iAllele instanceof IAlleleBeeSpecies)) continue;
                species.add((IAlleleBeeSpecies)iAllele);
            }
            statistics.add(String.format("SPECIES (%s):", species.size()));
            statistics.add("-------------");
            statistics.add("");
            for (IAlleleBeeSpecies iAlleleBeeSpecies : species) {
                statistics.add(this.generateSpeciesListEntry(iAlleleBeeSpecies, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/stats/" + player + ".log");
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.stats.error1"));
                return;
            }
            if (!file.canWrite()) {
                this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.stats.error2"));
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            bufferedWriter.write("# Forestry" + newLine + "# " + Version.getVersion() + newLine);
            for (String line : statistics) {
                bufferedWriter.write(line + newLine);
            }
            bufferedWriter.close();
        }
        catch (Exception ex) {
            this.sendChatMessage(sender, StringUtil.localize("chat.bees.command.stats.error3"));
            ex.printStackTrace();
        }
        this.sendChatMessage(sender, StringUtil.localizeAndFormat("chat.bees.command.stats.saved", player));
    }

    private String generateSpeciesListEntry(IAlleleBeeSpecies species, IApiaristTracker tracker) {
        String discovered = "[   ]";
        if (tracker.isDiscovered(species)) {
            discovered = "[ X ]";
        }
        String blacklisted = "[    ]";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = "[ BL ]";
        }
        String notcounted = "[    ]";
        if (!species.isCounted()) {
            notcounted = "[ NC ]";
        }
        return String.format("%s %s %s\t%-40s %-20s %-20s", discovered, blacklisted, notcounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private void listModes(ICommandSender sender, String[] arguments) {
        World world = this.getWorld(sender, arguments);
        String message = StringUtil.localize("chat.bees.command.mode.current");
        message = message.replaceAll("%MODE", PluginApiculture.beeInterface.getBeekeepingMode(world).getName());
        message = message.replaceAll("%WORLD", String.valueOf(world.func_72912_H().func_76088_k()));
        this.sendChatMessage(sender, message);
        String help = "";
        for (IBeekeepingMode mode : PluginApiculture.beeInterface.getBeekeepingModes()) {
            if (!help.isEmpty()) {
                help = help + ", ";
            }
            help = help + mode.getName();
        }
        this.sendChatMessage(sender, StringUtil.localizeAndFormat("chat.bees.command.mode.help", help));
    }

    private void listModeInfo(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 1) {
            throw new WrongUsageException("/" + this.func_71517_b() + " info <mode-name>", new Object[0]);
        }
        IBeekeepingMode found = null;
        for (IBeekeepingMode mode : PluginApiculture.beeInterface.getBeekeepingModes()) {
            if (!mode.getName().equalsIgnoreCase(arguments[1])) continue;
            found = mode;
            break;
        }
        if (found == null) {
            throw new CommandException("No beekeeping mode called '%s' is available.", new Object[]{arguments[1]});
        }
        this.sendChatMessage(sender, "\u00a7aMode: " + found.getName());
        for (String desc : found.getDescription()) {
            this.sendChatMessage(sender, StringUtil.localize(desc));
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return Proxies.common.isOp((EntityPlayer)sender);
        }
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List func_71516_a(ICommandSender sender, String[] incomplete) {
        return CommandBeekeepingMode.func_71530_a((String[])incomplete, (String[])this.modeStrings);
    }
}

