/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.SpeciesNotFoundException;
import forestry.apiculture.TemplateNotFoundException;
import forestry.core.utils.CommandMC;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class CommandGiveBee
extends CommandMC {
    EnumBeeType type;

    public CommandGiveBee(EnumBeeType type) {
        this.type = type;
    }

    public String func_71517_b() {
        return "give" + this.type.toString().toLowerCase();
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " <player-name> <species-name>";
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        IBee bee;
        IAllele[] template;
        EntityPlayerMP player;
        if (arguments.length >= 2) {
            player = CommandGiveBee.func_82359_c((ICommandSender)sender, (String)arguments[0]);
            String parameter = arguments[1];
            IAllele species = null;
            for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
                if (!uid.equals(parameter) || !(AlleleManager.alleleRegistry.getAllele(uid) instanceof IAlleleBeeSpecies)) continue;
                species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(uid);
                break;
            }
            if (species == null) {
                for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                    if (!(allele instanceof IAlleleBeeSpecies) || !((IAlleleBeeSpecies)allele).getName().equals(parameter)) continue;
                    species = (IAlleleBeeSpecies)allele;
                    break;
                }
            }
            if (species == null) {
                throw new SpeciesNotFoundException(parameter);
            }
            template = PluginApiculture.beeInterface.getTemplate(species.getUID());
            if (template == null) {
                throw new TemplateNotFoundException((IAlleleSpecies)species);
            }
            IBeeGenome genome = PluginApiculture.beeInterface.templateAsGenome(template);
            bee = PluginApiculture.beeInterface.getBee(player.field_70170_p, genome);
            if (this.type == EnumBeeType.QUEEN) {
                bee.mate(bee);
            }
        } else {
            throw new WrongUsageException("/" + this.func_71517_b() + " <player-name> <species-name>", new Object[0]);
        }
        ItemStack beestack = PluginApiculture.beeInterface.getMemberStack(bee, this.type.ordinal());
        player.func_71019_a(beestack, true);
        CommandGiveBee.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Player %s was given a %s bee.", (Object[])new Object[]{player.func_70005_c_(), ((IAlleleSpecies)template[0]).getName()});
    }

    public List func_71516_a(ICommandSender sender, String[] parameters) {
        if (parameters.length == 1) {
            return CommandGiveBee.func_71530_a((String[])parameters, (String[])this.getPlayers());
        }
        if (parameters.length == 2) {
            return CommandGiveBee.func_71530_a((String[])parameters, (String[])this.getSpecies());
        }
        return null;
    }

    protected String[] getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            species.add(((IAlleleSpecies)allele).getName());
        }
        return species.toArray(new String[0]);
    }
}

