/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeListener;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.interfaces.ICrafter;
import forestry.core.network.GuiId;
import forestry.core.utils.InventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileAlvearySieve
extends TileAlveary
implements ICrafter,
IBeeListener {
    public static final int BLOCK_META = 7;
    public static final int SLOT_POLLEN_1 = 0;
    public static final int SLOTS_POLLEN_COUNT = 4;
    public static final int SLOT_SIEVE = 4;
    InventoryAdapter inventory = new InventoryAdapter(5, "Items", 1);

    public TileAlvearySieve() {
        super(7);
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySieveGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public String getInventoryName() {
        return "alveary.7.name";
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasMaster() || !this.isIntegratedIntoStructure()) {
            return;
        }
        ((IAlvearyComponent)this.getCentralTE()).registerBeeListener(this);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.field_145850_b.func_82737_E() % 200L != 0L) {
            return;
        }
        if (!this.hasMaster() || !this.isIntegratedIntoStructure()) {
            return;
        }
        ((IAlvearyComponent)this.getCentralTE()).registerBeeListener(this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (side == 0 || side == 1) {
            return 2;
        }
        return 13;
    }

    private void destroySieve() {
        this.inventory.func_70299_a(4, null);
    }

    private void destroyPollen() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.func_70299_a(i, null);
        }
    }

    private boolean canStorePollen() {
        if (this.inventory.func_70301_a(4) == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    private void storePollenStack(ItemStack itemstack) {
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.func_70301_a(i) != null) continue;
            this.inventory.func_70299_a(i, itemstack);
            return;
        }
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        return true;
    }

    @Override
    public ItemStack takenFromSlot(int slotIndex, boolean consumeRecipe, EntityPlayer player) {
        if (slotIndex == 4) {
            this.destroyPollen();
            return this.inventory.func_70301_a(4);
        }
        this.destroySieve();
        return this.inventory.func_70301_a(slotIndex);
    }

    @Override
    public ItemStack getResult() {
        return null;
    }

    @Override
    public void onQueenChange(ItemStack queen) {
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public void onQueenDeath(IBee queen) {
    }

    @Override
    public void onPostQueenDeath(IBee queen) {
    }

    @Override
    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        if (isHandled) {
            return isHandled;
        }
        if (!this.canStorePollen()) {
            return false;
        }
        this.storePollenStack(AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass()).getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal()));
        return true;
    }

    @Override
    public boolean onEggLaid(IBee queen) {
        return false;
    }
}

