/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial(String uid) {
        super(uid, "glacial", false, 200, true, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        EnumTemperature temp = EnumTemperature.getFromValue(BiomeGenBase.func_150568_d((int)housing.getBiomeId()).field_76750_F);
        switch (temp) {
            case HELLISH: 
            case HOT: 
            case WARM: {
                return storedData;
            }
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(world.field_73012_v.nextInt(area.x), world.field_73012_v.nextInt(area.y), world.field_73012_v.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
            if (block != Blocks.field_150355_j || !world.func_147437_c(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            Proxies.common.setBlockWithNotify(world, posBlock.x, posBlock.y, posBlock.z, Blocks.field_150432_aD);
        }
        return storedData;
    }
}

