/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.plugins.PluginApiculture;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class AlleleEffectMiasmic
extends AlleleEffectThrottled {
    private final int infectionChance = 50;

    public AlleleEffectMiasmic(String uid) {
        super(uid, "misasmic", false, 50, false, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        if (this.isHalted(storedData, housing)) {
            return storedData;
        }
        AxisAlignedBB infectionBox = this.getBounding(genome, housing, 1.0f);
        List list = world.func_72872_a(EntityPlayer.class, infectionBox);
        for (Object obj : list) {
            if (world.field_73012_v.nextInt(1000) >= 50) continue;
            EntityPlayer player = (EntityPlayer)obj;
            int duration = 800;
            int count = ItemArmorApiarist.wearsItems(player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                duration = 200;
            } else if (count > 1) {
                duration = 400;
            } else if (count > 0) {
                duration = 600;
            }
            player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, duration, 0));
        }
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        if (housing.getWorld().field_73012_v.nextBoolean()) {
            PluginApiculture.proxy.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
        } else {
            PluginApiculture.proxy.addBeeHiveFX("particles/poison", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), 0xFFFFFF, area[0], area[1], area[2]);
        }
        return storedData;
    }
}

