/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.MutationReqRes;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import java.lang.reflect.Field;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MutationEMC
extends MutationReqRes {
    int emcRequired = 0;
    Class<?> condenserClass;
    Field emcField;

    public MutationEMC(IAllele allele0, IAllele allele1, IAllele[] template, int chance, ItemStack blockRequired, Class<?> condenserClass, Field emcField, int emcRequired) {
        super(allele0, allele1, template, chance, blockRequired);
        this.condenserClass = condenserClass;
        this.emcField = emcField;
        this.emcRequired = emcRequired;
    }

    @Override
    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        Vect[] possibleTargets;
        float chance = super.getChance(housing, allele0, allele1, genome0, genome1);
        if (chance <= 0.0f) {
            return 0.0f;
        }
        if (this.emcRequired <= 0) {
            return chance;
        }
        World world = housing.getWorld();
        for (Vect target : possibleTargets = new Vect[]{new Vect(housing.getXCoord() + 1, housing.getYCoord(), housing.getZCoord()), new Vect(housing.getXCoord() - 1, housing.getYCoord(), housing.getZCoord()), new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord() + 1), new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord() - 1)}) {
            TileEntity entity;
            if (!world.func_72899_e(target.x, target.y, target.z) || (entity = world.func_147438_o(target.x, target.y, target.z)) == null) continue;
            if (!this.condenserClass.isInstance(entity)) {
                Proxies.log.warning("Did not find a relay at " + target.toString());
                continue;
            }
            int emc = 0;
            try {
                emc = this.emcField.getInt(entity);
            }
            catch (Exception ex) {
                Proxies.log.warning("Failed to fetch EMC information.");
            }
            if (emc < this.emcRequired * 80) continue;
            boolean removedEMC = false;
            try {
                this.emcField.set(entity, emc - this.emcRequired * 80);
                removedEMC = true;
            }
            catch (Exception ex) {
                Proxies.log.warning("Failed to set EMC information.");
            }
            if (!removedEMC) continue;
            return chance;
        }
        return 0.0f;
    }
}

