/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.apiculture.gui.ContainerBeealyzer;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.items.ItemBeealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiBeealyzer
extends GuiAlyzer {
    private ItemStack[] tempProductList;

    public GuiBeealyzer(EntityPlayer player, ItemBeealyzer.BeealyzerInventory inventory) {
        super(AlleleManager.alleleRegistry.getSpeciesRoot("rootBees"), player, new ContainerBeealyzer(player.field_71071_by, inventory), inventory, 1, inventory.func_70302_i_());
        this.guiName = "gui.beealyzer";
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE.item()).addCreativeItems(beeList, false);
        for (ItemStack beeStack : beeList) {
            this.iconStacks.put(PluginApiculture.beeInterface.getMember(beeStack).getIdent(), beeStack);
        }
        this.breedingTracker = PluginApiculture.beeInterface.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        int page = 0;
        IBee bee = null;
        EnumBeeType beeType = EnumBeeType.DRONE;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.func_70301_a(k) == null) continue;
            bee = PluginApiculture.beeInterface.getMember(this.inventory.func_70301_a(k));
            beeType = PluginApiculture.beeInterface.getType(this.inventory.func_70301_a(k));
            if (bee == null || !bee.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(bee, beeType);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(bee, beeType);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(bee, beeType);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(bee);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(bee);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsPage1(IBee bee, EnumBeeType type) {
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.active"), 85);
        this.drawLine(StringUtil.localize("gui.inactive"), 150);
        this.newLine();
        this.newLine();
        String customPrimaryBeeKey = "bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getPrimary().getUnlocalizedName().replace("bees.species.", "");
        String customSecondaryBeeKey = "bees.custom.beealyzer." + type.getName() + "." + bee.getGenome().getSecondary().getUnlocalizedName().replace("bees.species.", "");
        this.drawSpeciesRow(StringUtil.localize("gui.species"), bee, EnumBeeChromosome.SPECIES, this.checkCustomName(customPrimaryBeeKey), this.checkCustomName(customSecondaryBeeKey));
        this.drawRow(StringUtil.localize("gui.lifespan"), bee.getGenome().getActiveAllele(EnumBeeChromosome.LIFESPAN.ordinal()).getName(), bee.getGenome().getInactiveAllele(EnumBeeChromosome.LIFESPAN.ordinal()).getName(), bee, EnumBeeChromosome.LIFESPAN);
        this.drawRow(StringUtil.localize("gui.speed"), bee.getGenome().getActiveAllele(EnumBeeChromosome.SPEED.ordinal()).getName(), bee.getGenome().getInactiveAllele(EnumBeeChromosome.SPEED.ordinal()).getName(), bee, EnumBeeChromosome.SPEED);
        this.drawRow(StringUtil.localize("gui.pollination"), bee.getGenome().getActiveAllele(EnumBeeChromosome.FLOWERING.ordinal()).getName(), bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWERING.ordinal()).getName(), bee, EnumBeeChromosome.FLOWERING);
        this.drawRow(StringUtil.localize("gui.flowers"), bee.getGenome().getFlowerProvider().getDescription(), ((IAlleleFlowers)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FLOWER_PROVIDER.ordinal())).getProvider().getDescription(), bee, EnumBeeChromosome.FLOWER_PROVIDER);
        this.drawLine(StringUtil.localize("gui.fertility"), 12);
        this.drawFertilityInfo(bee.getGenome().getFertility(), 85, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()), 0);
        this.drawFertilityInfo(((IAlleleInteger)bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal())).getValue(), 150, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY.ordinal()).isDominant()), 0);
        this.newLine();
        int[] areaAr = bee.getGenome().getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        this.drawRow(StringUtil.localize("gui.area"), area.toString(), ((AlleleArea)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TERRITORY.ordinal())).getArea().toString(), bee, EnumBeeChromosome.TERRITORY);
        this.drawRow(StringUtil.localize("gui.effect"), bee.getGenome().getEffect().getName(), ((IAlleleBeeEffect)bee.getGenome().getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal())).getName(), bee, EnumBeeChromosome.EFFECT);
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(IBee bee, EnumBeeType type) {
        String displayText;
        String nocturnal1;
        String diurnal1;
        String nocturnal0;
        String diurnal0;
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.active"), 85);
        this.drawLine(StringUtil.localize("gui.inactive"), 150);
        this.newLine();
        this.newLine();
        this.drawRow(StringUtil.localize("gui.climate"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getTemperature()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getTemperature()), bee, EnumBeeChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.temptol"), 12);
        this.drawToleranceInfo(bee.getGenome().getToleranceTemp(), 85, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal())).getValue(), 150, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.drawRow(StringUtil.localize("gui.humidity"), AlleleManager.climateHelper.toDisplay(bee.getGenome().getPrimary().getHumidity()), AlleleManager.climateHelper.toDisplay(bee.getGenome().getSecondary().getHumidity()), bee, EnumBeeChromosome.SPECIES);
        this.drawLine(StringUtil.localize("gui.humidtol"), 12);
        this.drawToleranceInfo(bee.getGenome().getToleranceHumid(), 85, this.getColorCoding(bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.drawToleranceInfo(((AlleleTolerance)bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal())).getValue(), 150, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal()).isDominant()));
        this.newLine();
        this.newLine();
        String yes = StringUtil.localize("yes");
        String no = StringUtil.localize("no");
        if (bee.getGenome().getNocturnal()) {
            nocturnal0 = diurnal0 = yes;
        } else {
            nocturnal0 = bee.getGenome().getPrimary().isNocturnal() ? yes : no;
            String string = diurnal0 = !bee.getGenome().getPrimary().isNocturnal() ? yes : no;
        }
        if (((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.NOCTURNAL.ordinal())).getValue()) {
            nocturnal1 = diurnal1 = yes;
        } else {
            nocturnal1 = bee.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal1 = !bee.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        this.drawLine(StringUtil.localize("gui.diurnal"), 12);
        this.drawLine(diurnal0, 85, this.getColorCoding(false));
        this.drawLine(diurnal1, 150, this.getColorCoding(false));
        this.newLine();
        this.drawLine(StringUtil.localize("gui.nocturnal"), 12);
        this.drawLine(nocturnal0, 85, this.getColorCoding(false));
        this.drawLine(nocturnal1, 150, this.getColorCoding(false));
        this.newLine();
        String primary = StringUtil.readableBoolean(bee.getGenome().getTolerantFlyer(), yes, no);
        String secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERANT_FLYER.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.flyer"), primary, secondary, bee, EnumBeeChromosome.TOLERANT_FLYER);
        primary = StringUtil.readableBoolean(bee.getGenome().getCaveDwelling(), yes, no);
        secondary = StringUtil.readableBoolean(((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING.ordinal())).getValue(), yes, no);
        this.drawRow(StringUtil.localize("gui.cave"), primary, secondary, bee, EnumBeeChromosome.CAVE_DWELLING);
        this.newLine();
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            displayText = "bees.stock.pristine";
            if (!bee.isNatural()) {
                displayText = "bees.stock.ignoble";
            }
            displayText = StringUtil.localize(displayText);
            this.drawCenteredLine(displayText, 8, 208, this.fontColor.get("gui.beealyzer.binomial"));
        }
        if (bee.getGeneration() >= 0) {
            this.newLine();
            displayText = StringUtil.localizeAndFormat("gui.beealyzer.generations", bee.getGeneration());
            this.drawCenteredLine(displayText, 8, 208, this.fontColor.get("gui.beealyzer.binomial"));
        }
        this.endPage();
    }

    private void drawAnalyticsPage3(IBee bee, EnumBeeType type) {
        this.tempProductList = bee.getProduceList();
        this.startPage(12, 85, 150);
        this.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : this.tempProductList) {
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : bee.getSpecialtyList()) {
            field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, (int)((float)(this.field_147003_i + x) * (1.0f / this.factor)), (int)((float)(this.field_147009_r + this.getLineY()) * (1.0f / this.factor)));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }
}

