/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CommandTreekeepingMode
extends CommandMC {
    String[] modeStrings = new String[PluginArboriculture.treeInterface.getTreekeepingModes().size()];

    public CommandTreekeepingMode() {
        for (int i = 0; i < PluginArboriculture.treeInterface.getTreekeepingModes().size(); ++i) {
            this.modeStrings[i] = PluginArboriculture.treeInterface.getTreekeepingModes().get(i).getName();
        }
    }

    public int compareTo(Object arg0) {
        return this.func_71517_b().compareTo(((ICommand)arg0).func_71517_b());
    }

    public String func_71517_b() {
        return "treekeeping";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " help";
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new WrongUsageException(StringUtil.localizeAndFormat("chat.help", this.func_71518_a(sender)), new Object[0]);
        }
        if (arguments[0].matches("list")) {
            this.listModes(sender, arguments);
        } else if (arguments[0].matches("info")) {
            this.listModeInfo(sender, arguments);
        } else if (arguments[0].matches("set")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " set [<world-#>] <mode-name>", new Object[0]);
            }
            World world = this.getWorld(sender, arguments);
            String desired = arguments[arguments.length - 1];
            ITreekeepingMode mode = PluginArboriculture.treeInterface.getTreekeepingMode(desired);
            if (mode == null) {
                throw new CommandException(StringUtil.localize("chat.trees.command.treekeeping.error"), new Object[]{desired});
            }
            PluginArboriculture.treeInterface.setTreekeepingMode(world, mode.getName());
            CommandTreekeepingMode.func_152373_a((ICommandSender)sender, (ICommand)this, (String)StringUtil.localize("chat.trees.command.treekeeping.set"), (Object[])new Object[]{mode.getName()});
        } else if (arguments[0].matches("save")) {
            if (arguments.length <= 1) {
                throw new WrongUsageException("/" + this.func_71517_b() + " save <player-name>", new Object[0]);
            }
            this.saveStatistics(sender, arguments);
        } else if (arguments[0].matches("help")) {
            this.sendChatMessage(sender, StringUtil.localizeAndFormat("chat.trees.command.help.0", this.func_71517_b()));
            this.sendChatMessage(sender, StringUtil.localize("chat.trees.command.help.1"));
            this.sendChatMessage(sender, StringUtil.localize("chat.trees.command.help.2"));
            this.sendChatMessage(sender, StringUtil.localize("chat.trees.command.help.3"));
            this.sendChatMessage(sender, StringUtil.localize("chat.trees.command.help.4"));
            this.sendChatMessage(sender, StringUtil.localize("chat.trees.command.help.5"));
        }
    }

    private void saveStatistics(ICommandSender sender, String[] arguments) {
        String newLine = System.getProperty("line.separator");
        World world = this.getWorld(sender, arguments);
        String player = arguments[1];
        ArrayList<String> statistics = new ArrayList<String>();
        statistics.add(String.format("Treekeeping statistics for %s on %s:", player, DateFormat.getInstance().format(new Date())));
        statistics.add("");
        statistics.add("MODE: " + PluginArboriculture.treeInterface.getTreekeepingMode(world).getName());
        statistics.add("");
        GameProfile profile = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(player);
        IArboristTracker tracker = PluginArboriculture.treeInterface.getBreedingTracker(world, profile);
        if (tracker == null) {
            statistics.add("No statistics found.");
        } else {
            statistics.add("BRED:");
            statistics.add("-----");
            statistics.add("");
            ArrayList<IAlleleTreeSpecies> species = new ArrayList<IAlleleTreeSpecies>();
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(iAllele instanceof IAlleleTreeSpecies)) continue;
                species.add((IAlleleTreeSpecies)iAllele);
            }
            statistics.add(String.format("SPECIES (%s):", species.size()));
            statistics.add("-------------");
            statistics.add("");
            for (IAlleleTreeSpecies iAlleleTreeSpecies : species) {
                statistics.add(this.generateSpeciesListEntry(iAlleleTreeSpecies, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/stats/" + player + ".log");
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                this.sendChatMessage(sender, "Log file could not be created. Failed to save statistics.");
                return;
            }
            if (!file.canWrite()) {
                this.sendChatMessage(sender, "Cannot write to log file. Failed to save statistics.");
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            bufferedWriter.write("# Forestry" + newLine + "# " + Version.getVersion() + newLine);
            for (String line : statistics) {
                bufferedWriter.write(line + newLine);
            }
            bufferedWriter.close();
        }
        catch (Exception ex) {
            this.sendChatMessage(sender, "Write operation threw an exception. Failed to save statistics.");
            ex.printStackTrace();
        }
        this.sendChatMessage(sender, "Saved statistics for player " + player);
    }

    private String generateSpeciesListEntry(IAlleleTreeSpecies species, IArboristTracker tracker) {
        String discovered = "[   ]";
        if (tracker.isDiscovered(species)) {
            discovered = "[ X ]";
        }
        String blacklisted = "[    ]";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = "[ BL ]";
        }
        String notcounted = "[    ]";
        if (!species.isCounted()) {
            notcounted = "[ NC ]";
        }
        return String.format("%s %s %s\t%-40s %-20s %-20s", discovered, blacklisted, notcounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private void listModes(ICommandSender sender, String[] arguments) {
        World world = this.getWorld(sender, arguments);
        this.sendChatMessage(sender, "Current: " + PluginArboriculture.treeInterface.getTreekeepingMode(world).getName() + " (#" + world.func_72912_H().func_76088_k() + ")");
        String help = "";
        for (ITreekeepingMode mode : PluginArboriculture.treeInterface.getTreekeepingModes()) {
            if (!help.isEmpty()) {
                help = help + ", ";
            }
            help = help + mode.getName();
        }
        this.sendChatMessage(sender, "Available modes: " + help);
    }

    private void listModeInfo(ICommandSender sender, String[] arguments) {
        if (arguments.length <= 1) {
            throw new WrongUsageException("/" + this.func_71517_b() + " info <mode-name>", new Object[0]);
        }
        ITreekeepingMode found = null;
        for (ITreekeepingMode mode : PluginArboriculture.treeInterface.getTreekeepingModes()) {
            if (!mode.getName().equalsIgnoreCase(arguments[1])) continue;
            found = mode;
            break;
        }
        if (found == null) {
            throw new CommandException("No treekeeping mode called '%s' is available.", new Object[]{arguments[1]});
        }
        this.sendChatMessage(sender, "\u00a7aMode: " + found.getName());
        for (String desc : found.getDescription()) {
            this.sendChatMessage(sender, StringUtil.localize(desc));
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        if (sender instanceof EntityPlayer) {
            return Proxies.common.isOp((EntityPlayer)sender);
        }
        return sender.func_70003_b(4, this.func_71517_b());
    }

    public List func_71516_a(ICommandSender sender, String[] incomplete) {
        return CommandTreekeepingMode.func_71530_a((String[])incomplete, (String[])this.modeStrings);
    }
}

