/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodType;
import forestry.plugins.PluginArboriculture;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockArbFence
extends BlockFence
implements IWoodTyped {
    private final FenceCat cat;

    public BlockArbFence(FenceCat cat) {
        super("", Material.field_151575_d);
        this.cat = cat;
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149766_f);
        this.func_149647_a(Tabs.tabArboriculture);
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        int count = this.cat == FenceCat.CAT0 ? 16 : 8;
        for (int i = 0; i < count; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_149826_e(IBlockAccess world, int x, int y, int z) {
        if (!this.isFence(world, x, y, z)) {
            Block block = world.func_147439_a(x, y, z);
            return block != null && block.func_149688_o().func_76218_k() && block.func_149686_d() ? block.func_149688_o() != Material.field_151572_C : false;
        }
        return true;
    }

    public int func_149645_b() {
        return PluginArboriculture.modelIdFences;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        WoodType.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.getWoodType(meta).getPlankIcon();
    }

    public boolean isFence(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return PluginArboriculture.validFences.contains(block);
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    @Override
    public WoodType getWoodType(int meta) {
        if (this.cat.ordinal() * 16 + meta < WoodType.VALUES.length) {
            return WoodType.VALUES[this.cat.ordinal() * 16 + meta];
        }
        return WoodType.LARCH;
    }

    @Override
    public String getBlockKind() {
        return "fences";
    }

    public static enum FenceCat {
        CAT0,
        CAT1;

    }
}

