/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.core.IToolScoop;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.arboriculture.gadgets.BlockTreeContainer;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import forestry.plugins.PluginLepidopterology;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLeaves
extends BlockTreeContainer {
    int[] adjacentTreeBlocks;
    @SideOnly(value=Side.CLIENT)
    private static IIcon defaultIcon;

    public BlockLeaves() {
        super(Material.field_151584_j);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(field_149779_h);
    }

    public static TileLeaves getLeafTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileLeaves)) {
            return null;
        }
        return (TileLeaves)tile;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileLeaves();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        ItemStack held;
        int metadata = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, metadata) && (held = player.field_71071_by.func_70448_g()) != null && held.func_77973_b() instanceof IToolGrafter) {
            float saplingModifier = 1.0f;
            saplingModifier = ((IToolGrafter)held.func_77973_b()).getSaplingModifier(held, world, player, x, y, z);
            held.func_77972_a(1, (EntityLivingBase)player);
            if (held.field_77994_a <= 0) {
                player.func_71028_bD();
            }
            this.spawnLeafDrops(world, x, y, z, metadata, saplingModifier, false);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        int offset = 1;
        int shift = offset + 1;
        if (world.func_72904_c(x - shift, y - shift, z - shift, x + shift, y + shift, z + shift)) {
            for (int i = -offset; i <= offset; ++i) {
                for (int j = -offset; j <= offset; ++j) {
                    for (int k = -offset; k <= offset; ++k) {
                        Block neighborBlock = world.func_147439_a(x + i, y + j, z + k);
                        neighborBlock.beginLeavesDecay(world, x + i, y + j, z + k);
                    }
                }
            }
        }
        this.spawnLeafDrops(world, x, y, z, metadata, 1.0f, true);
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return StackUtils.EMPTY_STACK_LIST;
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.spawnLeafDrops(world, x, y, z, world.func_72805_g(x, y, z), 1.0f, true);
        world.func_147468_f(x, y, z);
    }

    private void spawnLeafDrops(World world, int x, int y, int z, int metadata, float saplingModifier, boolean doFruitDrop) {
        for (ItemStack drop : this.getLeafDrop(world, x, y, z, metadata, saplingModifier, doFruitDrop)) {
            if (drop == null) continue;
            StackUtils.dropItemStackAsEntity(drop, world, x, y, z);
        }
    }

    private ArrayList<ItemStack> getLeafDrop(World world, int x, int y, int z, int metadata, float saplingModifier, boolean doFruitDrop) {
        ITree[] saplings;
        ArrayList<ItemStack> prod = new ArrayList<ItemStack>();
        TileLeaves tile = BlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return prod;
        }
        if (tile.getTree() == null) {
            return prod;
        }
        for (ITree iTree : saplings = tile.getTree().getSaplings(world, x, y, z, saplingModifier)) {
            if (iTree == null) continue;
            prod.add(PluginArboriculture.treeInterface.getMemberStack(iTree, EnumGermlingType.SAPLING.ordinal()));
        }
        if (doFruitDrop && tile.hasFruit()) {
            for (ITree iTree : tile.getTree().produceStacks(world, x, y, z, tile.getRipeningTime())) {
                prod.add((ItemStack)iTree);
            }
        }
        return prod;
    }

    public boolean func_149662_c() {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public int func_149645_b() {
        return PluginArboriculture.modelIdLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerFoliage.func_77470_a((double)var1, (double)var3);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y, z);
        if (leaves == null) {
            return ColorizerFoliage.func_77468_c();
        }
        int colour = leaves.getFoliageColour((EntityPlayer)Proxies.common.getClientInstance().field_71439_g);
        if (colour == PluginArboriculture.proxy.getFoliageColorBasic()) {
            colour = world.func_72807_a(x, z).func_150571_c(x, y, z);
        }
        return colour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTex(register, "leaves/deciduous.fancy");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y, z);
        if (leaves != null) {
            return leaves.getIcon(Proxies.render.fancyGraphicsEnabled());
        }
        return defaultIcon;
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random random) {
        super.func_149674_a(world, x, y, z, random);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 8) != 0 && (meta & 4) == 0) {
            int var12;
            int offset = 4;
            int shift = offset + 1;
            int var9 = 32;
            int var10 = var9 * var9;
            int var11 = var9 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[var9 * var9 * var9];
            }
            if (world.func_72904_c(x - shift, y - shift, z - shift, x + shift, y + shift, z + shift)) {
                int var14;
                int var13;
                for (var12 = -offset; var12 <= offset; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            Block block = world.func_147439_a(x + var12, y + var13, z + var14);
                            this.adjacentTreeBlocks[(var12 + var11) * var10 + (var13 + var11) * var9 + var14 + var11] = block.canSustainLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? 0 : (block.isLeaves((IBlockAccess)world, x + var12, y + var13, z + var14) ? -2 : -1);
                        }
                    }
                }
                for (var12 = 1; var12 <= 4; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            for (int var15 = -offset; var15 <= offset; ++var15) {
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11] != var12 - 1) continue;
                                if (this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] = var12;
                            }
                        }
                    }
                }
            }
            if ((var12 = this.adjacentTreeBlocks[var11 * var10 + var11 * var9 + var11]) >= 0) {
                world.func_72921_c(x, y, z, meta & 0xFFFFFFF7, 2);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 2);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 60;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        IButterfly caterpillar;
        ItemStack heldItem = player.func_70694_bm();
        TileEntity tile = world.func_147438_o(x, y, z);
        IButterfly iButterfly = caterpillar = tile instanceof TileLeaves ? ((TileLeaves)tile).getCaterpillar() : null;
        if (heldItem != null && heldItem.func_77973_b() instanceof IToolScoop && caterpillar != null) {
            StackUtils.dropItemStackAsEntity(PluginLepidopterology.butterflyInterface.getMemberStack(caterpillar, EnumFlutterType.CATERPILLAR.ordinal()), world, x, y, z);
            ((TileLeaves)tile).setCaterpillar(null);
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, par6, par7, par8, par9);
    }
}

