/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.arboriculture.genetics.Tree;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketTileNBT;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;

public abstract class TileTreeContainer
extends TileEntity
implements INetworkedEntity,
IOwnable {
    private ITree containedTree;
    public GameProfile owner = null;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.func_74775_l("ContainedTree"));
        }
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("ContainedTree", (NBTBase)subcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (tree != null) {
            this.sendNetworkUpdate();
        }
    }

    public ITree getTree() {
        return this.containedTree;
    }

    public boolean canUpdate() {
        return false;
    }

    public abstract void onBlockTick();

    public Packet func_145844_m() {
        return new PacketTileNBT(5, this).getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(new PacketTileNBT(5, this), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketTileNBT packet = (PacketTileNBT)packetRaw;
        this.func_145839_a(packet.getTagCompound());
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean allowsRemoval(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean allowsInteraction(EntityPlayer player) {
        return true;
    }

    @Override
    public EnumAccess getAccess() {
        return EnumAccess.SHARED;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.func_146103_bH();
    }

    public void setOwner(GameProfile playername) {
        this.owner = playername;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (this.owner != null) {
            return this.owner.equals((Object)player.func_146103_bH());
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        return false;
    }
}

