/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IGenome;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.genetics.Allele;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class Tree
extends Individual
implements ITree,
ITreeGenData,
IPlantable {
    private ITreeGenome genome;
    private ITreeGenome mate;
    private EnumPlantType plantType;

    public Tree(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Tree(ITreeGenome genome) {
        this.genome = genome;
    }

    public Tree(World world, ITreeGenome genome) {
        this.genome = genome;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.genome = nbttagcompound.func_74764_b("Genome") ? new TreeGenome(nbttagcompound.func_74775_l("Genome")) : PluginArboriculture.treeInterface.templateAsGenome(TreeTemplates.getOakTemplate());
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        if (this.genome != null) {
            NBTmachine = new NBTTagCompound();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Genome", (NBTBase)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new NBTTagCompound();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Mate", (NBTBase)NBTmachine);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = new TreeGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, World world, int biomeid, int x, int y, int z) {
        IAlleleLeafEffect effect = (IAlleleLeafEffect)this.getGenome().getActiveAllele(EnumTreeChromosome.EFFECT.ordinal());
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], world, biomeid, x, y, z);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleLeafEffect secondary = (IAlleleLeafEffect)this.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, biomeid, x, y, z);
        return storedData;
    }

    private IEffectData doEffect(IAlleleLeafEffect effect, IEffectData storedData, World world, int biomeid, int x, int y, int z) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, x, y, z);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, World world, int biomeid, int x, int y, int z) {
        return null;
    }

    @Override
    public WorldGenerator getTreeGenerator(World world, int x, int y, int z, boolean wasBonemealed) {
        return this.genome.getPrimary().getGenerator(this, world, x, y, z);
    }

    @Override
    public boolean canStay(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == null) {
            return false;
        }
        Iterator i$ = this.getPlantTypes().iterator();
        while (i$.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)i$.next();
            if (!block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return this.plantType;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z, int expectedGirth, int expectedHeight) {
        return this.genome.getGrowthProvider().canGrow(this.genome, world, x, y, z, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getMaturationTime();
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(World world, int x, int y, int z) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, x, y, z);
    }

    @Override
    public int getGirth(World world, int x, int y, int z) {
        return this.genome.getGirth();
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getFertility() * this.getGenome().getSappiness() * 100.0f);
        return (base > 1 ? base : 1) * 10;
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getHeight();
    }

    @Override
    public void setLeaves(World world, GameProfile owner, int x, int y, int z) {
        PluginArboriculture.treeInterface.setLeaves(world, this, owner, x, y, z);
    }

    @Override
    public boolean allowsFruitBlocks() {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        if (!provider.requiresFruitBlocks()) {
            return false;
        }
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        return suitable.contains(provider.getFamily());
    }

    @Override
    public boolean trySpawnFruitBlock(World world, int x, int y, int z) {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        if (!suitable.contains(provider.getFamily())) {
            return false;
        }
        return provider.trySpawnFruitBlock(this.getGenome(), world, x, y, z);
    }

    @Override
    public ITreeGenome getGenome() {
        return this.genome;
    }

    @Override
    public ITree copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }

    @Override
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean isPureBred(EnumTreeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome.ordinal()).getUID().equals(this.genome.getInactiveAllele(chromosome.ordinal()).getUID());
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        EnumSet<EnumPlantType> tolerated = this.genome.getPlantTypes();
        tolerated.add(this.genome.getPrimary().getPlantType());
        return tolerated;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleTreeSpecies primary = this.genome.getPrimary();
        IAlleleTreeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumTreeChromosome.SPECIES)) {
            list.add("\u00a79" + StringUtil.localize("trees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        list.add(String.format("\u00a76S: %s, \u00a7cM: %s", this.genome.getActiveAllele(EnumTreeChromosome.SAPPINESS.ordinal()).getName(), this.genome.getActiveAllele(EnumTreeChromosome.MATURATION.ordinal()).getName()));
        list.add(String.format("\u00a7dH: %s, \u00a7bG: %sx%s", this.genome.getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal()).getName(), this.genome.getGirth(), this.genome.getGirth()));
        list.add(String.format("\u00a7eS: %s, \u00a7fY: %s", this.genome.getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).getName(), this.genome.getActiveAllele(EnumTreeChromosome.YIELD.ordinal()).getName()));
        IAllele fruit = this.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal());
        if (fruit != Allele.fruitNone) {
            String strike = "";
            if (!this.canBearFruit()) {
                strike = "\u00a7m";
            }
            list.add(strike + "\u00a7aF: " + StringUtil.localize(this.genome.getFruitProvider().getDescription()));
        }
    }

    @Override
    public ITree[] getSaplings(World world, int x, int y, int z, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getFertility() * modifier;
        if (world.field_73012_v.nextFloat() <= chance) {
            if (this.getMate() == null) {
                prod.add(PluginArboriculture.treeInterface.getTree(world, new TreeGenome(this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, x, y, z));
            }
        }
        return prod.toArray(new ITree[0]);
    }

    private ITree createOffspring(World world, int x, int y, int z) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated = this.mutateSpecies(world, x, y, z, this.genome, this.mate);
        if (mutated == null) {
            mutated = this.mutateSpecies(world, x, y, z, this.mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(world, new TreeGenome(mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        return new Tree(world, new TreeGenome(chromosomes));
    }

    private IChromosome[] mutateSpecies(World world, int x, int y, int z, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (ITreeMutation mutation : PluginArboriculture.treeInterface.getMutations(true)) {
            float f;
            float chance = 0.0f;
            chance = mutation.getChance(world, x, y, z, allele0, allele1, genome0, genome1);
            if (!(f > 0.0f) || !(world.field_73012_v.nextFloat() * 100.0f < chance)) continue;
            return PluginArboriculture.treeInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getPrimary().getSuitableFruit().contains(this.genome.getFruitProvider().getFamily());
    }

    @Override
    public ItemStack[] getProduceList() {
        return this.genome.getFruitProvider().getProducts();
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        return this.genome.getFruitProvider().getSpecialty();
    }

    @Override
    public ItemStack[] produceStacks(World world, int x, int y, int z, int ripeningTime) {
        return this.genome.getFruitProvider().getFruits(this.genome, world, x, y, z, ripeningTime);
    }
}

