/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenAcacia
extends WorldGenTree {
    public WorldGenAcacia(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        float rnd = this.world.field_73012_v.nextFloat();
        int offset = 0;
        if (rnd > 0.6f) {
            offset = this.rand.nextInt(this.girth);
        } else if ((double)rnd > 0.3) {
            offset = -this.rand.nextInt(this.girth);
        }
        this.generateAdjustedCylinder(leafSpawn--, offset, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        this.generateAdjustedCylinder(leafSpawn--, offset, 1.5f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        if (this.rand.nextBoolean()) {
            this.generateAdjustedCylinder(leafSpawn--, offset, 3.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        } else {
            this.generateAdjustedCylinder(leafSpawn--, offset, 2.9f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log1, 2);
    }
}

