/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenEbony
extends WorldGenTree {
    public WorldGenEbony(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        int offset = (this.girth - 1) / 2;
        int trunksgenerated = 0;
        for (int x = -offset; x < -offset + this.girth; ++x) {
            for (int z = -offset; z < -offset + this.girth; ++z) {
                int i;
                if (this.rand.nextFloat() < 0.6f) {
                    for (i = 0; i < this.height; ++i) {
                        this.addWood(x, i, z, WorldGenBase.EnumReplaceMode.ALL);
                        if (i > this.height / 2 && this.rand.nextFloat() < 0.1f * (float)(10 / this.height)) break;
                    }
                    ++trunksgenerated;
                    continue;
                }
                for (i = 0; i < 1; ++i) {
                    this.clearBlock(x, i, z);
                }
            }
        }
        if (trunksgenerated <= 0) {
            this.generateTreeTrunk(this.height, 1, 0.6f);
        }
        for (int times = 0; times < 2 * this.height; ++times) {
            int h = 2 * this.girth + this.rand.nextInt(this.height - this.girth);
            if (this.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + this.rand.nextInt(this.height / 2);
            }
            int x_off = -this.girth + this.rand.nextInt(2 * this.girth);
            int y_off = -this.girth + this.rand.nextInt(2 * this.girth);
            this.generateSphere(new WorldGenBase.Vector(x_off, h, y_off), 1 + this.rand.nextInt(this.girth), this.leaf, WorldGenBase.EnumReplaceMode.NONE);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(10, 4);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log3, 1);
    }
}

