/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IPlugin;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.EventHandlerCore;
import forestry.core.ForestryConstants;
import forestry.core.GameMode;
import forestry.core.GuiHandler;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.config.Version;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.gadgets.TileMill;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.plugins.NativePlugin;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.io.File;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;

public class ForestryCore {
    public void preInit(File modLocation, Object basemod) {
        ForestryAPI.instance = basemod;
        ForestryAPI.forestryConstants = new ForestryConstants();
        PluginManager.loadPlugins(modLocation);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCore());
        Config.load();
        if (!Config.disableVersionCheck) {
            Version.versionCheck();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!(plugin instanceof PluginCore)) continue;
            plugin.preInit();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (plugin instanceof PluginCore) continue;
            if (plugin.isAvailable()) {
                plugin.preInit();
                continue;
            }
            Proxies.log.fine("Skipped plugin " + plugin.getClass() + " because preconditions were not met.");
        }
    }

    public void init(Object basemod) {
        this.registerLiquidContainers();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator(), (int)0);
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerCompound.getItemStack(), new FermenterFuel(ForestryItem.fertilizerCompound.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.fertilizer"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.fertilizer")));
        FuelManager.fermenterFuel.put(ForestryItem.fertilizerBio.getItemStack(), new FermenterFuel(ForestryItem.fertilizerBio.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.fermenterFuel.put(ForestryItem.mulch.getItemStack(), new FermenterFuel(ForestryItem.mulch.getItemStack(), GameMode.getGameMode().getIntegerSetting("fermenter.value.compost"), GameMode.getGameMode().getIntegerSetting("fermenter.cycles.compost")));
        FuelManager.moistenerResource.put(new ItemStack(Items.field_151015_O), new MoistenerFuel(new ItemStack(Items.field_151015_O), ForestryItem.mouldyWheat.getItemStack(), 0, 300));
        FuelManager.moistenerResource.put(ForestryItem.mouldyWheat.getItemStack(), new MoistenerFuel(ForestryItem.mouldyWheat.getItemStack(), ForestryItem.decayingWheat.getItemStack(), 1, 600));
        FuelManager.moistenerResource.put(ForestryItem.decayingWheat.getItemStack(), new MoistenerFuel(ForestryItem.decayingWheat.getItemStack(), ForestryItem.mulch.getItemStack(), 2, 900));
        FuelManager.copperEngineFuel.put(ForestryItem.peat.getItemStack(), new EngineCopperFuel(ForestryItem.peat.getItemStack(), 1, 5000));
        FuelManager.copperEngineFuel.put(ForestryItem.bituminousPeat.getItemStack(), new EngineCopperFuel(ForestryItem.bituminousPeat.getItemStack(), 2, 6000));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("biomass"), new EngineBronzeFuel(LiquidHelper.getFluid("biomass"), 5, (int)(2500.0f * GameMode.getGameMode().getFloatSetting("fuel.biomass.biogas")), 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("water"), new EngineBronzeFuel(LiquidHelper.getFluid("water"), 1, 1000, 3));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("milk"), new EngineBronzeFuel(LiquidHelper.getFluid("milk"), 1, 10000, 3));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("seedoil"), new EngineBronzeFuel(LiquidHelper.getFluid("seedoil"), 3, 2500, 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("honey"), new EngineBronzeFuel(LiquidHelper.getFluid("honey"), 2, 2500, 1));
        FuelManager.bronzeEngineFuel.put(LiquidHelper.getFluid("juice"), new EngineBronzeFuel(LiquidHelper.getFluid("juice"), 1, 2500, 1));
        FuelManager.rainSubstrate.put(ForestryItem.iodineCharge.getItemStack(), new RainSubstrate(ForestryItem.iodineCharge.getItemStack(), 10000, 0.01f));
        FuelManager.rainSubstrate.put(ForestryItem.craftingMaterial.getItemStack(1, 4), new RainSubstrate(ForestryItem.craftingMaterial.getItemStack(1, 4), 0.075f));
        for (int i = 0; i < 9; ++i) {
            FlowerManager.plainFlowers.add(new ItemStack((Block)Blocks.field_150328_O, 1, i));
        }
        FlowerManager.plainFlowers.add(new ItemStack((Block)Blocks.field_150327_N));
        NetworkRegistry.INSTANCE.registerGuiHandler(basemod, (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileMill.class, (String)"forestry.Grower");
        GameRegistry.registerTileEntity(TileEngine.class, (String)"forestry.Engine");
        GameRegistry.registerTileEntity(TileMachine.class, (String)"forestry.Machine");
    }

    public void postInit() {
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.doInit();
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.postInit();
        }
        Proxies.common.registerTickHandlers();
        this.processIMCMessages((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)ForestryAPI.instance));
    }

    public void serverStarting(MinecraftServer server) {
        CommandHandler commandManager = (CommandHandler)server.func_71187_D();
        for (IPlugin plugin : PluginManager.plugins) {
            ICommand[] commands;
            if (!plugin.isAvailable() || !(plugin instanceof NativePlugin) || (commands = ((NativePlugin)plugin).getConsoleCommands()) == null) continue;
            for (ICommand command : commands) {
                commandManager.func_71560_a(command);
            }
        }
    }

    public void processIMCMessages(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            IPlugin plugin;
            Iterator<IPlugin> i$ = PluginManager.plugins.iterator();
            while (!(!i$.hasNext() || (plugin = i$.next()) instanceof NativePlugin && ((NativePlugin)plugin).processIMCMessage(message))) {
            }
        }
    }

    public String getPriorities() {
        return "after:mod_IC2;after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_BuildCraftFactory;after:mod_BuildCraftSilicon;after:mod_BuildCraftTransport;after:mod_RedPowerWorld";
    }

    private void registerLiquidContainers() {
        if (LiquidHelper.isEmptyLiquidData()) {
            LiquidHelper.injectLiquidContainer("lava", 1000, new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151133_ar));
            LiquidHelper.injectLiquidContainer("water", 1000, new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151133_ar));
        }
        LiquidHelper.getOrCreateLiquid("glass");
        LiquidHelper.getOrCreateLiquid("milk");
        LiquidHelper.injectLiquidContainer("milk", 1000, new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151133_ar));
        LiquidHelper.injectTinContainer("lava", 1000, ForestryItem.canLava.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectRefractoryContainer("lava", 1000, ForestryItem.refractoryLava.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.injectLiquidContainer("water", 1000, new ItemStack((Item)Items.field_151068_bn, 1, 0), new ItemStack(Items.field_151069_bo));
        LiquidHelper.injectTinContainer("water", 1000, ForestryItem.canWater.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("water", 1000, ForestryItem.waxCapsuleWater.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("water", 1000, ForestryItem.refractoryWater.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("biomass");
        LiquidHelper.injectLiquidContainer("biomass", 1000, ForestryItem.bucketBiomass.getItemStack(), new ItemStack(Items.field_151133_ar));
        LiquidHelper.injectTinContainer("biomass", 1000, ForestryItem.canBiomass.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("biomass", 1000, ForestryItem.waxCapsuleBiomass.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("biomass", 1000, ForestryItem.refractoryBiomass.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("bioethanol");
        LiquidHelper.injectLiquidContainer("bioethanol", 1000, ForestryItem.bucketBiofuel.getItemStack(), new ItemStack(Items.field_151133_ar));
        LiquidHelper.injectTinContainer("bioethanol", 1000, ForestryItem.canBiofuel.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("bioethanol", 1000, ForestryItem.waxCapsuleBiofuel.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("bioethanol", 1000, ForestryItem.refractoryBiofuel.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("seedoil");
        LiquidHelper.injectTinContainer("seedoil", 1000, ForestryItem.canSeedOil.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("seedoil", 1000, ForestryItem.waxCapsuleSeedOil.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("seedoil", 1000, ForestryItem.refractorySeedOil.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("honey");
        LiquidHelper.injectTinContainer("honey", 1000, ForestryItem.canHoney.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("honey", 1000, ForestryItem.waxCapsuleHoney.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("honey", 1000, ForestryItem.refractoryHoney.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("juice");
        LiquidHelper.injectTinContainer("juice", 1000, ForestryItem.canJuice.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("juice", 1000, ForestryItem.waxCapsuleJuice.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("juice", 1000, ForestryItem.refractoryJuice.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
        LiquidHelper.getOrCreateLiquid("ice");
        LiquidHelper.injectTinContainer("ice", 1000, ForestryItem.canIce.getItemStack(), ForestryItem.canEmpty.getItemStack());
        LiquidHelper.injectWaxContainer("ice", 1000, ForestryItem.waxCapsuleIce.getItemStack(), ForestryItem.waxCapsule.getItemStack());
        LiquidHelper.injectRefractoryContainer("ice", 1000, ForestryItem.refractoryIce.getItemStack(), ForestryItem.refractoryEmpty.getItemStack());
    }
}

