/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.CreativeTabForestry;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Utils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlockForestry
extends BlockContainer {
    protected static boolean keepInventory = false;
    protected Random furnaceRand;

    public BlockForestry(Material material) {
        super(material);
        this.func_149711_c(1.5f);
        this.furnaceRand = new Random();
        this.func_149647_a(CreativeTabForestry.tabForestry);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        IOwnable tile = (IOwnable)world.func_147438_o(x, y, z);
        if (!tile.isOwnable() || tile.allowsRemoval(player)) {
            return super.removedByPlayer(world, player, x, y, z, willHarvest);
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileForestry) {
            TileForestry tileForestry = (TileForestry)tile;
            Utils.dropInventory(tileForestry, world, x, y, z);
            tileForestry.onRemoval();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack itemstack) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileForestry tile = (TileForestry)world.func_147438_o(i, j, k);
        if (entityliving instanceof EntityPlayer) {
            tile.owner = ((EntityPlayer)entityliving).func_146103_bH();
        }
    }
}

