/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSoil
extends Block {
    private final int degradeDelimiter = 3;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHumus;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconBogEarth;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPeat;

    public BlockSoil() {
        super(Material.field_151595_p);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149779_h);
        this.func_149647_a(CreativeTabForestry.tabForestry);
    }

    public int func_149738_a(World world) {
        return 500;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int type = metadata & 3;
        int maturity = metadata >> 2;
        if (maturity >= this.degradeDelimiter && type == 1) {
            ret.add(ForestryItem.peat.getItemStack());
            ret.add(new ItemStack(Blocks.field_150346_d));
        } else if (type == 0) {
            ret.add(new ItemStack(Blocks.field_150346_d));
        } else {
            ret.add(new ItemStack((Block)this, 1, type));
        }
        return ret;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) & 3;
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        if (type == 0) {
            this.updateTickHumus(world, i, j, k, random);
        } else if (type == 1) {
            this.updateTickBogEarth(world, i, j, k, random);
        } else {
            Proxies.log.warning(((Object)((Object)this)).getClass() + " with unknown type " + type + " encountered.");
        }
    }

    private void updateTickHumus(World world, int i, int j, int k, Random random) {
        if (this.isEnrooted(world, i, j, k)) {
            this.degradeSoil(world, i, j, k);
        }
    }

    private void updateTickBogEarth(World world, int i, int j, int k, Random random) {
        if (BlockSoil.isMoistened(world, i, j, k)) {
            this.matureBog(world, i, j, k);
        }
    }

    private boolean isEnrooted(World world, int x, int y, int z) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Block block = world.func_147439_a(x + i, y + 1, z + j);
                if (block != Blocks.field_150364_r && block != Blocks.field_150345_g && block != ForestryBlock.saplingGE.block()) continue;
                return i != 0 || j != 0;
            }
        }
        return false;
    }

    private void degradeSoil(World world, int i, int j, int k) {
        if (world.field_73012_v.nextInt(140) != 0) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        int grade = meta >> 2;
        meta = ++grade << 2 | type;
        if (grade >= this.degradeDelimiter) {
            world.func_147465_d(i, j, k, (Block)Blocks.field_150354_m, 0, 2);
        } else {
            world.func_72921_c(i, j, k, meta, 2);
        }
        world.func_147471_g(i, j, k);
    }

    public static boolean isMoistened(World world, int x, int y, int z) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                Block block = world.func_147439_a(x + i, y, z + j);
                if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                return true;
            }
        }
        return false;
    }

    private void matureBog(World world, int i, int j, int k) {
        if (world.field_73012_v.nextInt(13) != 0) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= this.degradeDelimiter) {
            return;
        }
        meta = ++maturity << 2 | type;
        world.func_72921_c(i, j, k, meta, 2);
        world.func_147471_g(i, j, k);
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        EnumPlantType plantType = plant.getPlantType(world, x, y, z);
        if (plantType != EnumPlantType.Crop && plantType != EnumPlantType.Plains) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return (meta & 3) == 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.iconHumus = TextureManager.getInstance().registerTex(register, "soil/humus");
        this.iconBogEarth = TextureManager.getInstance().registerTex(register, "soil/bog");
        this.iconPeat = TextureManager.getInstance().registerTex(register, "soil/peat");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        int meta = j;
        int type = meta & 0xF;
        int maturity = meta >> 2;
        if (type == 1) {
            if (maturity < this.degradeDelimiter) {
                return this.iconBogEarth;
            }
            return this.iconPeat;
        }
        if (type == 0) {
            return this.iconHumus;
        }
        return null;
    }
}

