/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Locale;

public class Classification
implements IClassification {
    private IClassification.EnumClassLevel level;
    private String uid;
    private String scientific;
    private IClassification parent;
    private ArrayList<IAlleleSpecies> members = new ArrayList();
    private ArrayList<IClassification> groups = new ArrayList();

    public Classification(IClassification.EnumClassLevel level, String uid, String scientific) {
        this.level = level;
        this.uid = level.name().toLowerCase(Locale.ENGLISH) + "." + uid;
        this.scientific = scientific;
        AlleleManager.alleleRegistry.registerClassification(this);
    }

    @Override
    public IClassification.EnumClassLevel getLevel() {
        return this.level;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public IClassification getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IClassification parent) {
        this.parent = parent;
    }

    @Override
    public String getScientific() {
        return this.scientific;
    }

    @Override
    public String getName() {
        return StringUtil.localize(this.uid);
    }

    @Override
    public String getDescription() {
        return StringUtil.localize(this.uid + ".description");
    }

    @Override
    public IClassification[] getMemberGroups() {
        return this.groups.toArray(new IClassification[0]);
    }

    @Override
    public void addMemberGroup(IClassification group) {
        this.groups.add(group);
        group.setParent(this);
    }

    @Override
    public IAlleleSpecies[] getMemberSpecies() {
        return this.members.toArray(new IAlleleSpecies[0]);
    }

    @Override
    public void addMemberSpecies(IAlleleSpecies species) {
        this.members.add(species);
    }
}

