/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IGenome;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class Genome
implements IGenome {
    private static final String SLOT_TAG = "Slot";
    private IChromosome[] chromosomes;

    public Genome(NBTTagCompound nbttagcompound) {
        this.chromosomes = new Chromosome[this.getDefaultTemplate().length];
        this.readFromNBT(nbttagcompound);
    }

    private IAllele[] getDefaultTemplate() {
        return this.getSpeciesRoot().getDefaultTemplate();
    }

    public Genome(IChromosome[] chromosomes) {
        if (chromosomes.length != this.getDefaultTemplate().length) {
            throw new IllegalArgumentException(String.format("Tried to create a genome for '%s' from an invalid chromosome template.", this.getSpeciesRoot().getUID()));
        }
        this.chromosomes = chromosomes;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Chromosomes", 10);
        this.chromosomes = new Chromosome[this.chromosomes.length];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(SLOT_TAG);
            if (byte0 < 0 || byte0 >= this.chromosomes.length) continue;
            Chromosome chromosome = Chromosome.loadChromosomeFromNBT(nbttagcompound1);
            this.chromosomes[byte0] = chromosome;
            if (Config.clearInvalidChromosomes) {
                chromosome.overrideInvalidAlleles(this.getDefaultTemplate()[byte0], this.getSpeciesRoot().getKaryotype()[byte0].getAlleleClass());
            }
            if (!chromosome.hasInvalidAlleles(this.getSpeciesRoot().getKaryotype()[byte0].getAlleleClass())) continue;
            throw new RuntimeException("Found Chromosome with invalid Alleles. See config option \"genetics.clear.invalid.chromosomes\".");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chromosomes.length; ++i) {
            if (this.chromosomes[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(SLOT_TAG, (byte)i);
            this.chromosomes[i].writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Chromosomes", (NBTBase)nbttaglist);
    }

    @Override
    public IChromosome[] getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public IAllele getActiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getActiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getInactiveAllele();
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] genetics = other.getChromosomes();
        if (this.chromosomes.length != genetics.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            if (chromosome == null && genetics[i] != null) {
                return false;
            }
            if (chromosome != null && genetics[i] == null) {
                return false;
            }
            if (chromosome == null && genetics[i] == null) continue;
            if (!chromosome.getPrimaryAllele().getUID().equals(genetics[i].getPrimaryAllele().getUID())) {
                return false;
            }
            if (chromosome.getSecondaryAllele().getUID().equals(genetics[i].getSecondaryAllele().getUID())) continue;
            return false;
        }
        return true;
    }
}

