/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.IToolPipette;
import forestry.core.gui.ContainerForestry;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketTankUpdate;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ForestryTank;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class ContainerLiquidTanks
extends ContainerForestry {
    private ILiquidTankContainer tanks;
    private Map<Integer, ForestryTank> syncedFluids = new HashMap<Integer, ForestryTank>();

    public ContainerLiquidTanks(IInventory inventory, ILiquidTankContainer tanks) {
        super(inventory);
        this.tanks = tanks;
    }

    public void handlePipetteClick(int slot, EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70445_o();
        if (itemstack == null) {
            return;
        }
        Item held = itemstack.func_77973_b();
        if (!(held instanceof IToolPipette)) {
            return;
        }
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            PacketPayload payload = new PacketPayload(1, 0, 0);
            payload.intPayload[0] = slot;
            Proxies.net.sendToServer(new PacketUpdate(40, payload));
            return;
        }
        IToolPipette pipette = (IToolPipette)held;
        int liquidAmount = this.tanks.getTanks()[slot].getFluid().amount;
        if (pipette.canPipette(itemstack) && liquidAmount > 0) {
            if (liquidAmount > 0) {
                int filled = pipette.fill(itemstack, this.tanks.getTanks()[slot].drain(1000, false), true);
                this.tanks.getTanks()[slot].drain(filled, true);
            }
        } else {
            ForestryTank tank = this.tanks.getTanks()[slot];
            FluidStack potential = pipette.drain(itemstack, pipette.getCapacity(itemstack), false);
            if (potential != null) {
                pipette.drain(itemstack, tank.fill(potential, true), true);
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.tanks.getTanks().length; ++i) {
            ForestryTank tank = this.tanks.getTanks()[i];
            if (tank.getFluid() == null && this.getTank(i).getFluidAmount() <= 0 || tank.getFluid() != null && tank.getFluid().isFluidStackIdentical(this.getTank(i).getFluid())) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                if (!(this.field_75149_d.get(j) instanceof EntityPlayerMP)) continue;
                EntityPlayerMP player = (EntityPlayerMP)this.field_75149_d.get(j);
                Proxies.net.sendToPlayer(new PacketTankUpdate(i, tank), (EntityPlayer)player);
            }
            this.syncedFluids.put(i, new ForestryTank(tank.getFluid() == null ? null : tank.getFluid().copy(), tank.getCapacity()));
        }
    }

    @Override
    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        short capacity = nbt.func_74765_d("capacity");
        this.tanks.getTanks()[tankID].readFromNBT(nbt);
        ForestryTank tank = new ForestryTank(capacity);
        tank.readFromNBT(nbt);
        this.syncedFluids.put(Integer.valueOf(tankID), tank);
    }

    @Override
    public ForestryTank getTank(int slot) {
        return this.syncedFluids.get(slot) == null ? ForestryTank.FAKETANK : this.syncedFluids.get(slot);
    }
}

