/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.config.SessionVars;
import forestry.core.gadgets.TileForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class LedgerManager {
    public GuiForestry<? extends TileForestry> gui;
    public Minecraft minecraft;
    protected ArrayList<Ledger> ledgers = new ArrayList();

    public LedgerManager(GuiForestry<? extends TileForestry> gui) {
        this.gui = gui;
        this.minecraft = Proxies.common.getClientInstance();
    }

    public void add(Ledger ledger) {
        this.ledgers.add(ledger);
        if (SessionVars.getOpenedLedger() != null && ledger.getClass().equals(SessionVars.getOpenedLedger())) {
            ledger.setFullyOpen();
        }
    }

    public void insert(Ledger ledger) {
        this.ledgers.add(this.ledgers.size() - 1, ledger);
    }

    protected Ledger getAtPosition(int mX, int mY) {
        int xShift = (this.gui.field_146294_l - this.gui.getSizeX()) / 2 + this.gui.getSizeX();
        int yShift = (this.gui.field_146295_m - this.gui.getSizeY()) / 2 + 8;
        for (int i = 0; i < this.ledgers.size(); ++i) {
            Ledger ledger = this.ledgers.get(i);
            if (!ledger.isVisible()) continue;
            ledger.currentShiftX = xShift;
            ledger.currentShiftY = yShift;
            if (ledger.intersectsWith(mX, mY, xShift, yShift)) {
                return ledger;
            }
            yShift += ledger.getHeight();
        }
        return null;
    }

    protected void drawLedgers() {
        int xPos = 8;
        for (Ledger ledger : this.ledgers) {
            ledger.update();
            if (!ledger.isVisible()) continue;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ledger.draw(this.gui.getSizeX(), xPos);
            xPos += ledger.getHeight();
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        Ledger ledger = this.getAtPosition(mouseX, mouseY);
        if (ledger != null) {
            int startX = mouseX - (this.gui.field_146294_l - this.gui.getSizeX()) / 2 + 12;
            int startY = mouseY - (this.gui.field_146295_m - this.gui.getSizeY()) / 2 - 12;
            String tooltip = ledger.getTooltip();
            int textWidth = this.minecraft.field_71466_p.func_78256_a(tooltip);
            this.gui.func_73733_a(startX - 3, startY - 3, startX + textWidth + 3, startY + 8 + 3, -1073741824, -1073741824);
            this.minecraft.field_71466_p.func_78261_a(tooltip, startX, startY, -1);
        }
    }

    public void handleMouseClicked(int x, int y, int mouseButton) {
        Ledger ledger;
        if (mouseButton == 0 && (ledger = this.getAtPosition(x, y)) != null && !ledger.handleMouseClicked(x, y, mouseButton)) {
            for (Ledger other : this.ledgers) {
                if (other == ledger || !other.isOpen()) continue;
                other.toggleOpen();
            }
            ledger.toggleOpen();
        }
    }
}

