/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import buildcraft.api.transport.PipeManager;
import forestry.api.core.ISpecialInventory;
import forestry.core.inventory.ITileFilter;
import forestry.core.inventory.ItemStackMap;
import forestry.core.inventory.filters.ArrayStackFilter;
import forestry.core.inventory.filters.IStackFilter;
import forestry.core.inventory.filters.InvertedStackFilter;
import forestry.core.inventory.filters.StackFilter;
import forestry.core.inventory.manipulators.InventoryManipulator;
import forestry.core.inventory.wrappers.ChestWrapper;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.inventory.wrappers.SidedInventoryMapper;
import forestry.core.inventory.wrappers.SpecialInventoryMapper;
import forestry.core.utils.PlainInventory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class InvTools {
    private static final String TAG_SLOT = "Slot";

    public static int getXOnSide(int x, ForgeDirection side) {
        return x + side.offsetX;
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        return y + side.offsetY;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        return z + side.offsetZ;
    }

    public static boolean blockExistsOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return world.func_72899_e(InvTools.getXOnSide(x, side), InvTools.getYOnSide(y, side), InvTools.getZOnSide(z, side));
    }

    public static int getBlockMetadataOnSide(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        return world.func_72805_g(InvTools.getXOnSide(i, side), InvTools.getYOnSide(j, side), InvTools.getZOnSide(k, side));
    }

    public static Block getBlockOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return world.func_147439_a(InvTools.getXOnSide(x, side), InvTools.getYOnSide(y, side), InvTools.getZOnSide(z, side));
    }

    public static TileEntity getBlockTileEntityOnSide(World world, int x, int y, int z, ForgeDirection side) {
        int sz;
        int sy;
        int sx = InvTools.getXOnSide(x, side);
        if (world.func_72899_e(sx, sy = InvTools.getYOnSide(y, side), sz = InvTools.getZOnSide(z, side))) {
            return world.func_147438_o(sx, sy, sz);
        }
        return null;
    }

    public static TileEntity getBlockTileEntityOnSide(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int sx = InvTools.getXOnSide(x, side);
        int sy = InvTools.getYOnSide(y, side);
        int sz = InvTools.getZOnSide(z, side);
        return world.func_147438_o(sx, sy, sz);
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventories(world, i, j, k, null);
    }

    public static List<IInventory> getAdjacentInventories(World world, int i, int j, int k, Class<? extends IInventory> type) {
        ArrayList<IInventory> list = new ArrayList<IInventory>(5);
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            list.add(inv);
        }
        return list;
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k) {
        return InvTools.getAdjacentInventoryMap(world, i, j, k, null);
    }

    public static Map<Integer, IInventory> getAdjacentInventoryMap(World world, int i, int j, int k, Class<? extends IInventory> type) {
        TreeMap<Integer, IInventory> map = new TreeMap<Integer, IInventory>();
        for (int side = 0; side < 6; ++side) {
            IInventory inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            map.put(side, inv);
        }
        return map;
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, final Class<? extends IInventory> type, final Class<? extends IInventory> exclude) {
        return InvTools.getInventoryFromSide(world, x, y, z, side, new ITileFilter(){

            @Override
            public boolean matches(TileEntity tile) {
                if (type != null && !type.isAssignableFrom(tile.getClass())) {
                    return false;
                }
                return exclude == null || !exclude.isAssignableFrom(tile.getClass());
            }
        });
    }

    public static IInventory getInventoryFromSide(World world, int x, int y, int z, ForgeDirection side, ITileFilter filter) {
        TileEntity tile = InvTools.getBlockTileEntityOnSide(world, x, y, z, side);
        if (tile == null || !(tile instanceof IInventory) || !filter.matches(tile)) {
            return null;
        }
        return InvTools.getInventoryFromTile(tile, side.getOpposite());
    }

    public static IInventory getInventoryFromTile(TileEntity tile, ForgeDirection side) {
        if (tile == null || !(tile instanceof IInventory)) {
            return null;
        }
        if (!PipeManager.canExtractItems(null, tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
            return null;
        }
        if (tile instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tile;
            return new ChestWrapper(chest);
        }
        return InvTools.getInventory((IInventory)tile, side);
    }

    public static IInventory getInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISpecialInventory) {
            inv = new SpecialInventoryMapper((ISpecialInventory)inv, side);
        } else if (inv instanceof ISidedInventory) {
            inv = new SidedInventoryMapper((ISidedInventory)inv, side);
        }
        return inv;
    }

    public static int[] buildSlotArray(int start, int size) {
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = start + i;
        }
        return slots;
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static ItemStack damageItem(ItemStack stack, int damage) {
        if (!stack.func_77984_f()) {
            return stack;
        }
        int curDamage = stack.func_77960_j();
        stack.func_77964_b(curDamage += damage);
        if (stack.func_77960_j() > stack.func_77958_k()) {
            --stack.field_77994_a;
            stack.func_77964_b(0);
        }
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
        return stack;
    }

    public static void dropItem(ItemStack stack, World world, double x, double y, double z) {
        if (stack == null || stack.field_77994_a < 1) {
            return;
        }
        EntityItem entityItem = new EntityItem(world, x, y + 1.5, z, stack);
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public static boolean isInventoryEmpty(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryEmpty(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> i$ = InventoryIterator.getIterable(inv).iterator();
        while (i$.hasNext() && (stack = (slot = i$.next()).getStackInSlot()) == null) {
        }
        return stack == null;
    }

    public static boolean isInventoryFull(IInventory inv, ForgeDirection side) {
        return InvTools.isInventoryFull(InvTools.getInventory(inv, side));
    }

    public static boolean isInventoryFull(IInventory inv) {
        IInvSlot slot;
        ItemStack stack = null;
        Iterator<IInvSlot> i$ = InventoryIterator.getIterable(inv).iterator();
        while (i$.hasNext() && (stack = (slot = i$.next()).getStackInSlot()) != null) {
        }
        return stack != null;
    }

    public static int countItems(IInventory inv) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static int countItems(IInventory inv, IStackFilter filter) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.field_77994_a;
        }
        return count;
    }

    public static boolean numItemsMoreThan(IInventory inv, int amount) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack != null) {
                count += stack.field_77994_a;
            }
            if (count < amount) continue;
            return true;
        }
        return false;
    }

    public static int countItems(IInventory inv, ItemStack ... filters) {
        if (inv instanceof InventoryMapper) {
            inv = ((InventoryMapper)inv).getBaseInventory();
        }
        boolean hasFilter = false;
        for (ItemStack filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (!hasFilter) {
            return InvTools.countItems(inv);
        }
        int count = 0;
        ItemStack stack = null;
        block1: for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            stack = inv.func_70301_a(slot);
            if (stack == null) continue;
            for (ItemStack filter : filters) {
                if (filter == null || !InvTools.isItemEqual(stack, filter)) continue;
                count += stack.field_77994_a;
                continue block1;
            }
        }
        return count;
    }

    public static int countItems(Collection<IInventory> inventories, ItemStack ... filter) {
        int count = 0;
        for (IInventory inv : inventories) {
            count += InvTools.countItems(inv, filter);
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ItemStack item) {
        return InvTools.countItems(inv, item) > 0;
    }

    public static Map<ItemStack, Integer> getManifest(IInventory inv) {
        ItemStackMap<Integer> manifest = new ItemStackMap<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            Integer count = (Integer)manifest.get(slot);
            if (count == null) {
                count = 0;
            }
            count = count + slot.field_77994_a;
            manifest.put(slot, count);
        }
        return manifest;
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new ArrayStackFilter(filters));
    }

    public static ItemStack moveOneItem(IInventory source, IInventory dest, IStackFilter filter) {
        InventoryManipulator imSource = InventoryManipulator.get(source);
        return imSource.moveItem(dest, filter);
    }

    public static ItemStack moveOneItem(Collection<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(Collection<IInventory> sources, IInventory dest, IStackFilter filter) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItem(inv, dest, filter);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItem(IInventory source, Collection<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItem(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, IInventory dest, ItemStack ... filters) {
        return InvTools.moveOneItem(source, dest, (IStackFilter)new InvertedStackFilter(new ArrayStackFilter(filters)));
    }

    public static ItemStack moveOneItemExcept(Collection<IInventory> sources, IInventory dest, ItemStack ... filters) {
        for (IInventory inv : sources) {
            ItemStack moved = InvTools.moveOneItemExcept(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ItemStack moveOneItemExcept(IInventory source, Collection<IInventory> destinations, ItemStack ... filters) {
        for (IInventory dest : destinations) {
            ItemStack moved = InvTools.moveOneItemExcept(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static boolean isWildcard(ItemStack stack) {
        return InvTools.isWildcard(stack.func_77960_j());
    }

    public static boolean isWildcard(int damage) {
        return damage == -1 || damage == Short.MAX_VALUE;
    }

    public static boolean isItemEqualStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.field_77994_a != b.field_77994_a) {
            return false;
        }
        if (a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isItemEqualSemiStrict(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (a.func_77960_j() != b.func_77960_j()) {
            return false;
        }
        return a.field_77990_d == null || a.field_77990_d.equals((Object)b.field_77990_d);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, true);
    }

    public static boolean isItemEqualIgnoreNBT(ItemStack a, ItemStack b) {
        return InvTools.isItemEqual(a, b, true, false);
    }

    public static boolean isItemEqual(ItemStack a, ItemStack b, boolean matchDamage, boolean matchNBT) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() != b.func_77973_b()) {
            return false;
        }
        if (matchNBT && !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (matchDamage && a.func_77981_g()) {
            if (InvTools.isWildcard(a) || InvTools.isWildcard(b)) {
                return true;
            }
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ItemStack stack, ItemStack ... matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack stack, Collection<ItemStack> matches) {
        for (ItemStack match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack moveItemStack(ItemStack stack, IInventory dest) {
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.addStack(stack);
    }

    public static boolean isRoomForStack(ItemStack stack, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        InventoryManipulator im = InventoryManipulator.get(dest);
        return im.canAddStack(stack);
    }

    public static ItemStack[] removeItems(IInventory inv, int numItems) {
        if (inv instanceof ISpecialInventory) {
            return ((ISpecialInventory)inv).extractItem(true, ForgeDirection.UNKNOWN, numItems);
        }
        PlainInventory output = new PlainInventory(27, "temp");
        for (int i = 0; i < inv.func_70302_i_() && numItems > 0; ++i) {
            ItemStack slot = inv.func_70301_a(i);
            if (slot == null) continue;
            ItemStack removed = inv.func_70298_a(i, numItems);
            numItems -= removed.field_77994_a;
            ItemStack remainder = InvTools.moveItemStack(removed, output);
            if (remainder == null) continue;
            InvTools.moveItemStack(remainder, inv);
            numItems += remainder.field_77994_a;
            break;
        }
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (ItemStack stack : output.getContents()) {
            if (stack == null) continue;
            list.add(stack);
        }
        return list.toArray(new ItemStack[0]);
    }

    public static ItemStack removeOneItem(IInventory inv) {
        return InvTools.removeOneItem(inv, (IStackFilter)StackFilter.ALL);
    }

    public static ItemStack removeOneItem(IInventory inv, ItemStack ... filter) {
        return InvTools.removeOneItem(inv, (IStackFilter)new ArrayStackFilter(filter));
    }

    public static ItemStack removeOneItem(IInventory inv, IStackFilter filter) {
        InventoryManipulator im = InventoryManipulator.get(inv);
        return im.removeItem(filter);
    }

    public static ItemStack removeOneItem(Collection<IInventory> invs, IStackFilter filter) {
        for (IInventory inv : invs) {
            ItemStack stack = InvTools.removeOneItem(inv, filter);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a(TAG_SLOT, slot);
            InvTools.writeItemToNBT(stack, itemTag);
            list.func_74742_a((NBTBase)itemTag);
        }
        data.func_74782_a(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.func_150295_c(tag, 10);
        for (int entry = 0; entry < list.func_74745_c(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.func_150305_b(entry);
            byte slot = itemTag.func_74771_c(TAG_SLOT);
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            inv.func_70299_a((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ItemStack stack, NBTTagCompound data) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (stack.field_77994_a > 127) {
            stack.field_77994_a = 127;
        }
        stack.func_77955_b(data);
    }
}

