/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.inventory.InvTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ItemStackSet
implements Set<ItemStack> {
    private final List<ItemStack> set = new ArrayList<ItemStack>();

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        ItemStack check = (ItemStack)obj;
        for (ItemStack stack : this.set) {
            if (!InvTools.isItemEqual(stack, check)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(ItemStack e) {
        if (this.contains(e)) {
            return false;
        }
        this.set.add(e);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        boolean changed = false;
        ItemStack check = (ItemStack)obj;
        Iterator<ItemStack> it = this.set.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (!InvTools.isItemEqual(stack, check)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (!(obj instanceof ItemStack)) {
                return false;
            }
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ItemStack> c) {
        boolean changed = false;
        for (ItemStack itemStack : c) {
            changed |= this.add(itemStack);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<ItemStack> it = this.set.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (c.contains(stack)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<ItemStack> it = this.set.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (!c.contains(stack)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.set.clear();
    }
}

