/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.INBTTagable;
import forestry.api.core.IToolPipette;
import forestry.core.config.Config;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    @SideOnly(value=Side.CLIENT)
    private IIcon primaryIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon secondaryIcon;

    public ItemPipette() {
        this.func_77625_d(1);
        this.func_77664_n();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public boolean canPipette(ItemStack itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        return !contained.isFull(1000);
    }

    @Override
    public int fill(ItemStack itemstack, FluidStack liquid, boolean doFill) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        int limit = this.getCapacity(itemstack);
        int filled = 0;
        if (contained.contents == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained.contents = new FluidStack(liquid.fluidID, filled);
            filled = liquid.amount;
        } else {
            if (contained.contents.amount >= limit) {
                return 0;
            }
            if (!contained.contents.isFluidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.contents.amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.contents.amount += filled;
        }
        if (doFill) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            contained.writeToNBT(nbttagcompound);
            itemstack.func_77982_d(nbttagcompound);
            itemstack.func_77964_b(1);
        }
        return filled;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        PipetteContents contained = new PipetteContents(itemstack.func_77978_p());
        contained.addTooltip(list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.primaryIcon = TextureManager.getInstance().registerTex(register, StringUtil.cleanItemName(this) + ".0");
        this.secondaryIcon = TextureManager.getInstance().registerTex(register, StringUtil.cleanItemName(this) + ".1");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage <= 0) {
            return this.primaryIcon;
        }
        return this.secondaryIcon;
    }

    @Override
    public FluidStack drain(ItemStack pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = new PipetteContents(pipette.func_77978_p());
        if (contained.contents == null || contained.contents.fluidID <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (contained.contents.amount < drained) {
            drained = contained.contents.amount;
        }
        if (doDrain) {
            contained.contents.amount -= drained;
            if (contained.contents.amount <= 0) {
                pipette.func_77982_d(null);
                pipette.func_77964_b(0);
            } else {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                contained.writeToNBT(nbttagcompound);
                pipette.func_77982_d(nbttagcompound);
            }
        }
        return new FluidStack(contained.contents.fluidID, drained);
    }

    @Override
    public int getCapacity(ItemStack pipette) {
        return 1000;
    }

    class PipetteContents
    implements INBTTagable {
        FluidStack contents;

        public PipetteContents(NBTTagCompound nbttagcompound) {
            if (nbttagcompound != null) {
                this.readFromNBT(nbttagcompound);
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            this.contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            if (this.contents != null) {
                this.contents.writeToNBT(nbttagcompound);
            }
        }

        public boolean isFull(int limit) {
            if (this.contents == null) {
                return false;
            }
            return this.contents.fluidID > 0 && this.contents.amount >= limit;
        }

        public void addTooltip(List<String> list) {
            if (this.contents == null) {
                return;
            }
            String descr = this.contents.getFluid().getLocalizedName(this.contents);
            if (Config.isDebug) {
                descr = descr + " (" + this.contents.amount + ")";
            }
            list.add(descr);
        }
    }
}

