/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.registry.GameData;
import forestry.core.proxy.Proxies;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class ForestryPacket {
    protected int id;
    protected static String channel = "FOR";

    public ForestryPacket() {
    }

    public ForestryPacket(int id) {
        this.id = id;
    }

    public FMLProxyPacket getPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(this.getID());
            this.writeData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])bytes.toByteArray()), channel);
    }

    public int getID() {
        return this.id;
    }

    protected ItemStack readItemStack(DataInputStream data) throws IOException {
        ItemStack itemstack = null;
        String itemName = data.readUTF();
        if (!itemName.isEmpty()) {
            Item item = (Item)GameData.getItemRegistry().getRaw(itemName);
            byte stackSize = data.readByte();
            short meta = data.readShort();
            itemstack = new ItemStack(item, (int)stackSize, (int)meta);
            if (item.func_77645_m() || Proxies.common.needsTagCompoundSynched(item)) {
                itemstack.field_77990_d = this.readNBTTagCompound(data);
            }
        }
        return itemstack;
    }

    protected void writeItemStack(ItemStack itemstack, DataOutputStream data) throws IOException {
        if (itemstack == null) {
            data.writeUTF("");
        } else {
            data.writeUTF(GameData.getItemRegistry().func_148750_c((Object)itemstack.func_77973_b()));
            data.writeByte(itemstack.field_77994_a);
            data.writeShort(itemstack.func_77960_j());
            if (itemstack.func_77973_b().func_77645_m() || Proxies.common.needsTagCompoundSynched(itemstack.func_77973_b())) {
                this.writeNBTTagCompound(itemstack.field_77990_d, data);
            }
        }
    }

    protected NBTTagCompound readNBTTagCompound(DataInputStream data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] compressed = new byte[length];
        data.readFully(compressed);
        return CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(compressed));
    }

    protected void writeNBTTagCompound(NBTTagCompound nbttagcompound, DataOutputStream data) throws IOException {
        if (nbttagcompound == null) {
            data.writeShort(-1);
        } else {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            data.writeShort((short)compressed.length);
            data.write(compressed);
        }
    }

    public void writeData(DataOutputStream data) throws IOException {
    }

    public void readData(DataInputStream data) throws IOException {
    }
}

