/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public abstract class Trigger
implements ITileTrigger {
    private final String uid;
    private final String unlocalized;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    public Trigger(String uid) {
        this(uid, uid);
    }

    public Trigger(String uid, String localization) {
        this.uid = "forestry." + uid;
        this.unlocalized = "trigger." + localization;
        ActionManager.registerTrigger(this);
    }

    @Override
    public String getUniqueTag() {
        return this.uid;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize(this.unlocalized);
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public boolean requiresParameter() {
        return false;
    }

    @Override
    public ITriggerParameter createParameter() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = TextureManager.getInstance().registerTex(register, "triggers/" + this.unlocalized.replace("trigger.", ""));
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }
}

