/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TilePowered;
import forestry.core.triggers.Trigger;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerLowFuel
extends Trigger {
    private float threshold = 0.25f;

    public TriggerLowFuel(String tag, float threshold) {
        super(tag, "lowFuel");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection direction, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TilePowered) {
            return !((TilePowered)tile).hasFuelMin(this.threshold);
        }
        if (tile instanceof Engine) {
            Engine engine = (Engine)tile;
            return !engine.hasFuelMin(this.threshold);
        }
        return false;
    }
}

