/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.config.Config;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.tooltips.ToolTipLine;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class ForestryTank
extends FluidTank {
    public static final ForestryTank FAKETANK = new ForestryTank(0);
    public static final ForestryTank[] FAKETANK_ARRAY = new ForestryTank[]{FAKETANK};
    public static final FluidTankInfo DUMMY_TANK_INFO = new FluidTankInfo((IFluidTank)FAKETANK);
    public static final FluidTankInfo[] DUMMY_TANKINFO_ARRAY = new FluidTankInfo[]{DUMMY_TANK_INFO};
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            ForestryTank.this.toolTip.clear();
            int amount = 0;
            if (ForestryTank.this.getFluid() != null && ForestryTank.this.getFluid().amount > 0 && ForestryTank.this.getFluid().getFluid() != null) {
                Fluid fluidType = ForestryTank.this.getFluidType();
                EnumRarity rarity = fluidType.getRarity();
                if (rarity == null) {
                    rarity = EnumRarity.common;
                }
                ToolTipLine fluidName = new ToolTipLine(fluidType.getLocalizedName(ForestryTank.this.getFluid()), rarity.field_77937_e);
                fluidName.setSpacing(2);
                ForestryTank.this.toolTip.add(fluidName);
                amount = ForestryTank.this.getFluid().amount;
            } else {
                ForestryTank.this.toolTip.add(new ToolTipLine(StringUtil.localize("gui.empty")));
            }
            if (Config.tooltipLiquidAmount) {
                ForestryTank.this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, ForestryTank.this.getCapacity())));
            }
        }
    };

    public ForestryTank(FluidStack stack, int capacity) {
        super(stack, capacity);
    }

    public ForestryTank(int capacity) {
        super(capacity);
    }

    public ForestryTank(Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount == this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public String toString() {
        return String.format("Tank: %s, %d/%d", this.fluid != null && this.fluid.getFluid() != null ? this.fluid.getFluid().getName() : "Empty", this.getFluidAmount(), this.getCapacity());
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }
}

