/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IDescriptiveRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedRecipeCustom
implements IDescriptiveRecipe {
    private final int width;
    private final int height;
    private final Object[] ingredients;
    private final ItemStack product;
    private boolean preserveNBT = false;

    public ShapedRecipeCustom(int width, int height, Object[] ingredients, ItemStack product) {
        this.width = width;
        this.height = height;
        this.ingredients = ingredients;
        this.product = product;
    }

    public ShapedRecipeCustom setPreserveNBT() {
        this.preserveNBT = true;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public ItemStack func_77571_b() {
        return this.product;
    }

    @Override
    public Object[] getIngredients() {
        return this.ingredients;
    }

    public boolean func_77569_a(InventoryCrafting inventorycrafting, World world) {
        ItemStack[][] resources = new ItemStack[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                resources[i][j] = inventorycrafting.func_70463_b(i, j);
            }
        }
        return this.matches(resources);
    }

    public boolean matches(ItemStack[][] resources) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.checkMatch(resources, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(resources, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(ItemStack[][] resources, int xInGrid, int yInGrid, boolean flag) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                int widthIt = k - xInGrid;
                int heightIt = l - yInGrid;
                Object compare = null;
                if (widthIt >= 0 && heightIt >= 0 && widthIt < this.width && heightIt < this.height) {
                    compare = flag ? this.ingredients[this.width - widthIt - 1 + heightIt * this.width] : this.ingredients[widthIt + heightIt * this.width];
                }
                ItemStack resource = resources[k][l];
                if (compare instanceof ItemStack) {
                    if (this.checkItemMatch((ItemStack)compare, resource)) continue;
                    return false;
                }
                if (compare instanceof ArrayList) {
                    boolean matched = false;
                    for (ItemStack item : (ArrayList)compare) {
                        matched = matched || this.checkItemMatch(item, resource);
                    }
                    if (matched) continue;
                    return false;
                }
                if (compare != null || resource == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemMatch(ItemStack compare, ItemStack resource) {
        if (resource == null && compare == null) {
            return true;
        }
        if (resource == null && compare != null || resource != null && compare == null) {
            return false;
        }
        if (compare.func_77973_b() != resource.func_77973_b()) {
            return false;
        }
        return compare.func_77960_j() == Short.MAX_VALUE || compare.func_77960_j() == resource.func_77960_j();
    }

    public ItemStack func_77572_b(InventoryCrafting inventorycrafting) {
        if (this.preserveNBT) {
            for (int i = 0; i < inventorycrafting.func_70302_i_(); ++i) {
                if (inventorycrafting.func_70301_a(i) == null || !inventorycrafting.func_70301_a(i).func_77942_o()) continue;
                ItemStack crafted = this.product.func_77946_l();
                crafted.func_77982_d((NBTTagCompound)inventorycrafting.func_70301_a(i).func_77978_p().func_74737_b());
                return crafted;
            }
        }
        return this.product.func_77946_l();
    }

    public int func_77570_a() {
        return this.width * this.height;
    }

    public boolean isIngredient(ItemStack resource) {
        for (Object ingredient : this.ingredients) {
            if (ingredient instanceof ItemStack) {
                if (!this.checkItemMatch((ItemStack)ingredient, resource)) continue;
                return true;
            }
            if (!(ingredient instanceof ArrayList)) continue;
            for (ItemStack item : (ArrayList)ingredient) {
                if (!this.checkItemMatch(item, resource)) continue;
                return true;
            }
        }
        return false;
    }

    public static ShapedRecipeCustom createShapedRecipe(ItemStack product, Object ... materials) {
        String s = "";
        int index = 0;
        int columns = 0;
        int rows = 0;
        if (materials[index] instanceof String[]) {
            String[] as = (String[])materials[index++];
            for (int l = 0; l < as.length; ++l) {
                String pattern = as[l];
                ++rows;
                columns = pattern.length();
                s = s + pattern;
            }
        } else {
            while (materials[index] instanceof String) {
                String pattern = (String)materials[index++];
                ++rows;
                columns = pattern.length();
                s = s + pattern;
            }
        }
        HashMap<Character, Object> hashmap = new HashMap<Character, Object>();
        while (index < materials.length) {
            Character character = (Character)materials[index];
            if (materials[index + 1] instanceof Item) {
                hashmap.put(character, new ItemStack((Item)materials[index + 1]));
            } else if (materials[index + 1] instanceof ForestryItem) {
                hashmap.put(character, ((ForestryItem)((Object)materials[index + 1])).getItemStack());
            } else if (materials[index + 1] instanceof ForestryBlock) {
                hashmap.put(character, ((ForestryBlock)((Object)materials[index + 1])).getItemStack());
            } else if (materials[index + 1] instanceof Block) {
                hashmap.put(character, new ItemStack((Block)materials[index + 1], 1, Short.MAX_VALUE));
            } else if (materials[index + 1] instanceof ItemStack) {
                hashmap.put(character, materials[index + 1]);
            } else if (materials[index + 1] instanceof String) {
                hashmap.put(character, OreDictionary.getOres((String)((String)materials[index + 1])));
            } else {
                throw new RuntimeException("Invalid Recipe Defined!");
            }
            index += 2;
        }
        Object[] ingredients = new Object[columns * rows];
        for (int l = 0; l < columns * rows; ++l) {
            char c = s.charAt(l);
            ingredients[l] = hashmap.containsKey(Character.valueOf(c)) ? hashmap.get(Character.valueOf(c)) : null;
        }
        return new ShapedRecipeCustom(columns, rows, ingredients, product);
    }

    public static ShapedRecipeCustom buildRecipe(ItemStack product, Object ... materials) {
        ShapedRecipeCustom recipe = ShapedRecipeCustom.createShapedRecipe(product, materials);
        CraftingManager.func_77594_a().func_77592_b().add(recipe);
        return recipe;
    }
}

