/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpecialInventory;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.network.PacketPayload;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TileInventoryAdapter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EngineBronze
extends Engine
implements ISpecialInventory,
ILiquidTankContainer {
    public static final short SLOT_CAN = 0;
    public ForestryTank fuelTank = new ForestryTank(10000);
    public ForestryTank heatingTank = new ForestryTank(10000);
    private final TileInventoryAdapter inventory;
    public int burnTime;
    public int totalTime;
    public int currentFluidId = -1;
    private boolean shutdown;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = super.getPacketPayload();
        if (this.shutdown) {
            payload.append(new int[]{1});
        } else {
            payload.append(new int[]{0});
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        super.fromPacketPayload(payload);
        this.shutdown = payload.intPayload[3] > 0;
    }

    public EngineBronze() {
        super(10000, 30000, 500);
        this.setHints(Config.hints.get("engine.bronze"));
        this.inventory = new TileInventoryAdapter(this, 1, "Items");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineBronzeGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        super.updateServerSide();
        if (this.inventory.func_70301_a(0) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(0))) != null) {
            ForestryTank tank = null;
            if (container.fluid.isFluidEqual(LiquidHelper.getLiquid("lava", 1))) {
                tank = this.heatingTank;
            } else if (FuelManager.bronzeEngineFuel.containsKey(container.fluid)) {
                tank = this.fuelTank;
            }
            if (tank != null) {
                this.inventory.func_70299_a(0, this.replenishByContainer(this.inventory.func_70301_a(0), container, tank));
                if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
                    this.inventory.func_70299_a(0, null);
                }
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (this.getHeatLevel() <= 0.2 && this.heatingTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOHEAT);
        } else if (this.burnTime <= 0 && this.fuelTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.isActivated() && (this.fuelTank.getFluidAmount() >= 1000 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.getFluidAmount() > 0 && this.heatingTank.getFluid().getFluid().getName().equals("lava")) {
                this.addHeat(20);
                this.heatingTank.drain(1, true);
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    this.currentOutput = this.determineFuelValue(FluidRegistry.getFluid((int)this.currentFluidId));
                    this.addEnergy(this.currentOutput);
                } else {
                    this.burnTime = this.totalTime = this.determineBurnTime(this.fuelTank.getFluid().getFluid());
                    this.currentFluidId = this.fuelTank.getFluid().getFluid().getID();
                    this.fuelTank.drain(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
        if (this.burnTime <= 0) {
            this.currentFluidId = -1;
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if ((fuel = FuelManager.bronzeEngineFuel.get(this.fuelTank.getFluid())) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.isActivated() && this.burnTime > 0) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private int determineFuelValue(Fluid fluid) {
        if (FuelManager.bronzeEngineFuel.containsKey(fluid)) {
            return FuelManager.bronzeEngineFuel.get((Object)fluid).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnTime(Fluid item) {
        if (FuelManager.bronzeEngineFuel.containsKey(item)) {
            return FuelManager.bronzeEngineFuel.get((Object)item).burnDuration;
        }
        return 0;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    public int getFuelScaled(int i) {
        return this.fuelTank.getFluidAmount() * i / 10000;
    }

    public int getHeatingFuelScaled(int i) {
        return this.heatingTank.getFluidAmount() * i / 10000;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        Fluid fluid;
        super.func_145839_a(nbt);
        this.burnTime = nbt.func_74762_e("EngineBurnTime");
        this.totalTime = nbt.func_74762_e("EngineTotalTime");
        if (nbt.func_74764_b("currentFluid") && (fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("currentFluid"))) != null) {
            this.currentFluidId = fluid.getID();
        }
        this.fuelTank = new ForestryTank(10000);
        this.heatingTank = new ForestryTank(10000);
        if (nbt.func_74764_b("FuelSlot")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("FuelSlot"));
            this.heatingTank.readFromNBT(nbt.func_74775_l("HeatingSlot"));
        }
        this.inventory.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("EngineBurnTime", this.burnTime);
        nbt.func_74768_a("EngineTotalTime", this.totalTime);
        Fluid fluid = FluidRegistry.getFluid((int)this.currentFluidId);
        if (fluid != null) {
            nbt.func_74778_a("currentFluid", fluid.getName());
        }
        NBTTagCompound nbtFuelSlot = new NBTTagCompound();
        NBTTagCompound nbtHeatingSlot = new NBTTagCompound();
        this.fuelTank.writeToNBT(nbtFuelSlot);
        this.heatingTank.writeToNBT(nbtHeatingSlot);
        nbt.func_74782_a("FuelSlot", (NBTBase)nbtFuelSlot);
        nbt.func_74782_a("HeatingSlot", (NBTBase)nbtHeatingSlot);
        this.inventory.writeToNBT(nbt);
    }

    @Override
    public void getGUINetworkData(int id, int data) {
        switch (id) {
            case 0: {
                this.burnTime = data;
                break;
            }
            case 1: {
                this.totalTime = data;
                break;
            }
            case 2: {
                this.currentOutput = data;
                break;
            }
            case 3: {
                this.storedEnergy = data;
                break;
            }
            case 4: {
                this.heat = data;
                break;
            }
            case 5: {
                this.currentFluidId = data;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.burnTime);
        iCrafting.func_71112_a(containerEngine, 1, this.totalTime);
        iCrafting.func_71112_a(containerEngine, 2, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 3, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 4, this.heat);
        iCrafting.func_71112_a(containerEngine, 5, this.currentFluidId);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public String func_145825_b() {
        return "engine.2.name";
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        return this.inventory.addStack(stack, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (FuelManager.bronzeEngineFuel.containsKey(resource)) {
            used = this.fuelTank.fill(resource, doFill);
        }
        if (LiquidHelper.isLiquid("lava", resource)) {
            used = this.heatingTank.fill(resource, doFill);
        }
        return used;
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.fuelTank, this.heatingTank};
    }
}

