/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gadgets.Engine;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.Ledger;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;

public abstract class GuiEngine
extends GuiForestry<Engine> {
    public GuiEngine(String texture, ContainerForestry container, Engine tile) {
        super(texture, container, (Object)tile);
    }

    @Override
    protected void initLedgers(Object inventory) {
        super.initLedgers(inventory);
        this.ledgerManager.insert(new EngineLedger((Engine)this.tile));
    }

    protected class EngineLedger
    extends Ledger {
        private final Engine engine;

        public EngineLedger(Engine engine) {
            super(GuiEngine.this.ledgerManager);
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = GuiEngine.this.fontColor.get("ledger.power.background");
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            this.drawIcon(TextureManager.getInstance().getDefault("misc/energy"), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.field_146289_q.func_78261_a(StringUtil.localize("gui.energy"), x + 22, y + 8, GuiEngine.this.fontColor.get("ledger.power.header"));
            GuiEngine.this.field_146289_q.func_78261_a(StringUtil.localize("gui.currentOutput") + ":", x + 22, y + 20, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.field_146289_q.func_78276_b(this.engine.getCurrentOutput() + " MJ/t", x + 22, y + 32, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.field_146289_q.func_78261_a(StringUtil.localize("gui.stored") + ":", x + 22, y + 44, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.field_146289_q.func_78276_b(this.engine.getEnergyStored() + " MJ", x + 22, y + 56, GuiEngine.this.fontColor.get("ledger.power.text"));
            GuiEngine.this.field_146289_q.func_78261_a(StringUtil.localize("gui.heat") + ":", x + 22, y + 68, GuiEngine.this.fontColor.get("ledger.power.subheader"));
            GuiEngine.this.field_146289_q.func_78276_b((double)this.engine.getHeat() / 10.0 + 20.0 + " C", x + 22, y + 80, GuiEngine.this.fontColor.get("ledger.power.text"));
        }

        @Override
        public String getTooltip() {
            return this.engine.getCurrentOutput() + " MJ/t";
        }
    }
}

