/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.WidgetManager;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.StringUtil;
import forestry.energy.gadgets.EngineBronze;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.GuiEngine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiEngineBronze
extends GuiEngine {
    EngineBronze tile;

    public GuiEngineBronze(InventoryPlayer inventory, EngineBronze tile) {
        super("textures/gui/bioengine.png", (ContainerForestry)new ContainerEngineBronze(inventory, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 89, 19, 0));
        this.widgetManager.add(new TankWidget(this.widgetManager, 107, 19, 1));
        this.widgetManager.add(new BiogasSlot(this.widgetManager, 30, 47, tile));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String name = StringUtil.localizeTile(this.tile.func_145825_b());
        this.field_146289_q.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        EngineBronze engine = this.tile;
        int temp = engine.getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends Widget {
        EngineBronze engine;

        public BiogasSlot(WidgetManager manager, int xPos, int yPos, EngineBronze engine) {
            super(manager, xPos, yPos);
            this.engine = engine;
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
            int x;
            if (this.engine == null || this.engine.totalTime <= 0) {
                return;
            }
            Fluid fluid = FluidRegistry.getFluid((int)this.engine.currentFluidId);
            if (fluid == null) {
                return;
            }
            IIcon liquidIcon = fluid.getIcon();
            if (liquidIcon == null) {
                return;
            }
            int squaled = this.engine.burnTime * this.height / this.engine.totalTime;
            if (squaled > this.height) {
                squaled = this.height;
            }
            Proxies.common.bindTexture(SpriteSheet.BLOCKS);
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                x = 0;
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
            Proxies.common.bindTexture(GuiEngineBronze.this.textureFile);
        }

        @Override
        public String getLegacyTooltip(EntityPlayer player) {
            Fluid fluid = FluidRegistry.getFluid((int)this.engine.currentFluidId);
            if (fluid == null) {
                return StringUtil.localize("gui.empty");
            }
            String tooltip = fluid.getLocalizedName(new FluidStack(fluid, 1));
            return tooltip;
        }
    }
}

