/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.power.PowerHandler;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IBottlerManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineBottler
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE = 0;
    public static final short SLOT_PRODUCT = 1;
    public static final short SLOT_CAN = 2;
    public static final short CYCLES_FILLING_DEFAULT = 5;
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    private final InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private boolean productPending = false;
    private Recipe currentRecipe;
    private final Stack<ItemStack> pendingProducts = new Stack();
    private int fillingTime;
    private int fillingTotalTime;

    public MachineBottler() {
        this.setHints(Config.hints.get("bottler"));
    }

    public String func_145825_b() {
        return "factory.0.name";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.BottlerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(50.0, 110.0, 5.0, 400.0);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("FillingTime", this.fillingTime);
        nbttagcompound.func_74768_a("FillingTotalTime", this.fillingTotalTime);
        nbttagcompound.func_74757_a("ProductPending", this.productPending);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingProducts.toArray(new ItemStack[this.pendingProducts.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingProducts", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.fillingTime = nbttagcompound.func_74762_e("FillingTime");
        this.fillingTotalTime = nbttagcompound.func_74762_e("FillingTotalTime");
        this.productPending = nbttagcompound.func_74767_n("ProductPending");
        this.resourceTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingProducts", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingProducts.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.field_145850_b.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        if (this.inventory.func_70301_a(2) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(2))) != null && RecipeManager.isInput(container.fluid)) {
            this.inventory.func_70299_a(2, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(2), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)2).field_77994_a <= 0) {
                this.inventory.func_70299_a(2, null);
            }
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.tryAddPending()) {
            return false;
        }
        if (!this.pendingProducts.isEmpty()) {
            return false;
        }
        if (this.fillingTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
            return false;
        }
        --this.fillingTime;
        if (this.fillingTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingProducts.push(this.currentRecipe.bottled.func_77946_l());
        this.inventory.func_70298_a(0, 1);
        this.resourceTank.drain(this.currentRecipe.input.amount, true);
        this.checkRecipe();
        this.resetRecipe();
        while (this.tryAddPending()) {
        }
        return true;
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.inventory.func_70301_a(0));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.fillingTime = 0;
            this.fillingTotalTime = 0;
            return;
        }
        this.fillingTime = this.currentRecipe.cyclesPerUnit;
        this.fillingTotalTime = this.currentRecipe.cyclesPerUnit;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ItemStack next = this.pendingProducts.peek();
        if (this.addProduct(next, true)) {
            this.pendingProducts.pop();
            return true;
        }
        this.setErrorState(EnumErrorCode.NOSPACE);
        return false;
    }

    private boolean addProduct(ItemStack product, boolean all) {
        return this.inventory.tryAddStack(product, 1, 1, all);
    }

    @Override
    public boolean isWorking() {
        return this.fillingTime > 0;
    }

    @Override
    public boolean hasResourcesMin(float percentage) {
        if (this.inventory.func_70301_a(0) == null) {
            return false;
        }
        return (float)this.inventory.func_70301_a((int)0).field_77994_a / (float)this.inventory.func_70301_a(0).func_77976_d() > percentage;
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null;
    }

    public int getFillProgressScaled(int i) {
        if (this.fillingTotalTime == 0) {
            return 0;
        }
        return this.fillingTime * i / this.fillingTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
                break;
            }
            case 1: {
                this.fillingTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.fillingTime);
        iCrafting.func_71112_a(container, 1, this.fillingTotalTime);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 1;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotIndex == 2) {
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && RecipeManager.isInput(container.fluid);
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!RecipeManager.isInput(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        LinkedList<ITrigger> res = new LinkedList<ITrigger>();
        res.add(ForestryTrigger.lowResource25);
        res.add(ForestryTrigger.lowResource10);
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements IBottlerManager {
        public static ArrayList<Recipe> recipes = new ArrayList();

        @Override
        public void addRecipe(int cyclesPerUnit, FluidStack input, ItemStack can, ItemStack bottled) {
            recipes.add(new Recipe(cyclesPerUnit, input, can, bottled));
        }

        public static Recipe findMatchingRecipe(FluidStack res, ItemStack empty) {
            ItemStack filled;
            if (res == null || empty == null) {
                return null;
            }
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (!recipe.matches(res, empty)) continue;
                return recipe;
            }
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)empty) && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)res, (ItemStack)empty)) != null) {
                RecipeManagers.bottlerManager.addRecipe(5, FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled), empty, filled);
                return RecipeManager.findMatchingRecipe(res, empty);
            }
            return null;
        }

        public static boolean isInput(FluidStack res) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = recipes.get(i);
                if (!recipe.hasInput(res)) continue;
                return true;
            }
            return FluidRegistry.isFluidRegistered((Fluid)res.getFluid());
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.input, recipe.can}, new Object[]{recipe.bottled});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int cyclesPerUnit;
        public final FluidStack input;
        public final ItemStack can;
        public final ItemStack bottled;

        public Recipe(int cyclesPerUnit, FluidStack input, ItemStack can, ItemStack bottled) {
            this.cyclesPerUnit = cyclesPerUnit;
            this.input = input;
            this.can = can;
            this.bottled = bottled;
        }

        public boolean matches(FluidStack res, ItemStack empty) {
            return this.input.isFluidEqual(res) && res.amount >= this.input.amount && this.can.func_77969_a(empty);
        }

        public boolean hasInput(FluidStack res) {
            return this.input.isFluidEqual(res);
        }
    }
}

