/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gadgets.BlockStructure;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.farming.gadgets.TileControl;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileGearbox;
import forestry.farming.gadgets.TileHatch;
import forestry.farming.gadgets.TileValve;
import forestry.plugins.PluginFarming;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFarm
extends BlockStructure {
    public BlockFarm() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 6; ++i) {
            if (i == 1) continue;
            for (TileFarm.EnumFarmBlock block : TileFarm.EnumFarmBlock.values()) {
                ItemStack stack = new ItemStack(item, 1, i);
                NBTTagCompound compound = new NBTTagCompound();
                block.saveToCompound(compound);
                stack.func_77982_d(compound);
                list.add(stack);
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, 0, 0);
        if (drops.isEmpty()) {
            return super.getPickBlock(target, world, x, y, z);
        }
        return drops.get(0);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_149689_a(world, x, y, z, entityliving, stack);
        if (!stack.func_77942_o()) {
            return;
        }
        TileFarm tile = (TileFarm)world.func_147438_o(x, y, z);
        tile.setFarmBlock(TileFarm.EnumFarmBlock.getFromCompound(stack.func_77978_p()));
    }

    @Override
    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        int meta = world.func_72805_g(x, y, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, meta)) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, 0, 0);
            for (ItemStack drop : drops) {
                StackUtils.dropItemStackAsEntity(drop, world, x, y, z);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        int meta = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileFarm) {
            TileFarm farm = (TileFarm)tile;
            ItemStack stack = new ItemStack((Block)this, 1, meta != 1 ? meta : 0);
            NBTTagCompound compound = new NBTTagCompound();
            farm.getFarmBlock().saveToCompound(compound);
            stack.func_77982_d(compound);
            drops.add(stack);
        }
        return drops;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta != 1 ? meta : 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 2: {
                return new TileGearbox();
            }
            case 3: {
                return new TileHatch();
            }
            case 4: {
                return new TileValve();
            }
            case 5: {
                return new TileControl();
            }
        }
        return new TileFarmPlain();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, meta);
    }

    public int func_149645_b() {
        return PluginFarming.modelIdFarmBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        TileFarm.EnumFarmBlock.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.getBlockTextureFromSideAndMetadata(TileFarm.EnumFarmBlock.BRICK, side, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockTextureFromSideAndMetadata(TileFarm.EnumFarmBlock type, int side, int metadata) {
        return StackUtils.getBlock(type.base).func_149691_a(side, type.base.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayTextureForBlock(int side, int metadata) {
        TileFarm.EnumFarmBlock type = TileFarm.EnumFarmBlock.BRICK_STONE;
        if (metadata == 0 && side == 2) {
            return type.getIcon(1);
        }
        if (metadata == 0 && (side == 0 || side == 1)) {
            return type.getIcon(2);
        }
        switch (metadata) {
            case 1: {
                return type.getIcon(3);
            }
            case 2: {
                return type.getIcon(4);
            }
            case 3: {
                return type.getIcon(5);
            }
            case 4: {
                return type.getIcon(6);
            }
            case 5: {
                return type.getIcon(7);
            }
        }
        return type.getIcon(0);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_72805_g(x, y, z) == 5;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ItemStack base = TileFarm.EnumFarmBlock.BRICK_STONE.base;
        if (tile instanceof TileFarm) {
            base = ((TileFarm)tile).farmBlock.base;
        }
        return StackUtils.getBlock(base).func_149691_a(side, base.func_77960_j());
    }
}

