/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.api.core.ITileStructure;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmComponent;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.Vect;
import forestry.farming.gadgets.TileFarm;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileControl
extends TileFarm
implements IFarmListener {
    private boolean isInited = false;

    public TileControl() {
        this.fixedType = 7;
    }

    @Override
    protected void updateServerSide() {
        if (!this.isInited) {
            this.registerWithMaster();
        }
    }

    @Override
    public void setCentralTE(TileEntity tile) {
        super.setCentralTE(tile);
        this.registerWithMaster();
    }

    private void registerWithMaster() {
        this.isInited = true;
        if (!this.hasMaster()) {
            return;
        }
        ITileStructure central = this.getCentralTE();
        if (!(central instanceof IFarmComponent)) {
            return;
        }
        ((IFarmComponent)central).registerListener(this);
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    public boolean cancelTask(IFarmLogic logic, ForgeDirection direction) {
        return this.hasRedstoneSignal(direction) || this.hasRedstoneSignal(ForgeDirection.UP) || this.hasRedstoneSignal(ForgeDirection.DOWN);
    }

    private boolean hasRedstoneSignal(ForgeDirection direction) {
        Vect side = new Vect(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        ForgeDirection opp = direction.getOpposite();
        int dir = opp.offsetZ < 0 ? 2 : (opp.offsetZ > 0 ? 3 : (opp.offsetX < 0 ? 4 : (opp.offsetX > 0 ? 5 : 0)));
        return this.field_145850_b.func_72878_l(side.x, side.y, side.z, dir) > 0 || this.field_145850_b.func_72879_k(side.x, side.y, side.z, dir) > 0;
    }

    @Override
    public boolean beforeCropHarvest(ICrop crop) {
        return false;
    }

    @Override
    public void afterCropHarvest(Collection<ItemStack> harvested, ICrop crop) {
    }

    @Override
    public void hasCollected(Collection<ItemStack> collected, IFarmLogic logic) {
    }

    @Override
    public void hasCultivated(IFarmLogic logic, int x, int y, int z, ForgeDirection direction, int extent) {
    }

    @Override
    public void hasScheduledHarvest(Collection<ICrop> harvested, IFarmLogic logic, int x, int y, int z, ForgeDirection direction, int extent) {
    }
}

