/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import buildcraft.api.gates.ITrigger;
import forestry.api.core.ITileStructure;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.plugins.PluginFarming;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class TileHatch
extends TileFarm
implements ISidedInventory {
    public TileHatch() {
        this.fixedType = 5;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void createInventory() {
    }

    @Override
    protected void updateServerSide() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.dumpStash();
        }
    }

    protected void dumpStash() {
        if (!this.hasMaster()) {
            return;
        }
        ArrayList<ForgeDirection> pipes = new ArrayList<ForgeDirection>();
        ForgeDirection[] tmp = BlockUtil.getPipeDirections(this.field_145850_b, this.Coords(), ForgeDirection.UP);
        for (int i = 0; i < tmp.length; ++i) {
            pipes.add(tmp[i]);
        }
        if (pipes.size() > 0) {
            this.dumpToPipe(pipes);
        } else {
            IInventory[] inventories = BlockUtil.getAdjacentInventories(this.field_145850_b, this.Coords(), ForgeDirection.UP);
            this.dumpToInventory(inventories);
        }
    }

    private void dumpToPipe(ArrayList<ForgeDirection> pipes) {
        ItemStack[] products = this.extractItem(true, ForgeDirection.DOWN, 1);
        for (int i = 0; i < products.length; ++i) {
            while (products[i].field_77994_a > 0) {
                BlockUtil.putFromStackIntoPipe(this, pipes, products[i]);
            }
        }
    }

    private void dumpToInventory(IInventory[] inventories) {
        ITileStructure central = this.getCentralTE();
        if (central == null) {
            return;
        }
        IInventory inv = central.getInventory();
        block0: for (int i = 12; i < 20; ++i) {
            if (inv.func_70301_a(i) == null) continue;
            ItemStack stack = inv.func_70301_a(i);
            if (stack.field_77994_a <= 0) continue;
            for (int j = 0; j < inventories.length; ++j) {
                if (inventories[j].func_70302_i_() < 4) continue;
                IInventory inventory = Utils.getChest(inventories[j]);
                if (inventory instanceof ISidedInventory) {
                    ISidedInventory sidedInventory = (ISidedInventory)inventory;
                    int[] slots = sidedInventory.func_94128_d(ForgeDirection.UP.ordinal());
                    for (int sl = 0; sl < slots.length; ++sl) {
                        StackUtils.stowInInventory(stack, (IInventory)sidedInventory, true, sl, 1);
                    }
                    continue;
                }
                StackUtils.stowInInventory(stack, inventory, true);
                if (stack.field_77994_a > 0) continue;
                inv.func_70299_a(i, null);
                continue block0;
            }
        }
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return (InventoryAdapter)this.getStructureInventory();
    }

    private IInventory getStructureInventory() {
        ITileStructure central;
        if (this.hasMaster() && (central = this.getCentralTE()) != null) {
            return central.getInventory();
        }
        return null;
    }

    public int func_70302_i_() {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70298_a(slotIndex, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            inv.func_70299_a(slotIndex, itemstack);
        }
    }

    public int func_70297_j_() {
        IInventory inv = this.getStructureInventory();
        if (inv != null) {
            return inv.func_70297_j_();
        }
        return 0;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex >= 12 && slotIndex < 20;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!this.hasMaster()) {
            return false;
        }
        ITileStructure struct = this.getCentralTE();
        if (!(struct instanceof TileFarmPlain)) {
            return false;
        }
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        TileFarmPlain housing = (TileFarmPlain)struct;
        if (slotIndex == 20 && housing.acceptsAsFertilizer(itemstack)) {
            return true;
        }
        if (slotIndex >= 0 && slotIndex < 6 && housing.acceptsAsResource(itemstack)) {
            return true;
        }
        if (slotIndex >= 6 && slotIndex < 12 && housing.acceptsAsGermling(itemstack)) {
            return true;
        }
        if (slotIndex == 21) {
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemstack);
        }
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return super.isUseableByPlayer(player);
    }

    public boolean func_145818_k_() {
        return super.hasCustomInventoryName();
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return super.isItemValidForSlot(slotIndex, itemstack);
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return super.canInsertItem(i, itemstack, j);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return super.canExtractItem(i, itemstack, j);
    }

    public int[] func_94128_d(int side) {
        return super.getAccessibleSlotsFromSide(side);
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.hasMaster()) {
            ITileStructure central = this.getCentralTE();
            if (central == null) {
                return new ItemStack[0];
            }
        } else {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        IInventory inv = this.getCentralTE().getInventory();
        ItemStack product = null;
        for (int i = 12; i < 20; ++i) {
            if (inv.func_70301_a(i) == null) continue;
            ItemStack stack = inv.func_70301_a(i);
            if (doRemove) {
                product = inv.func_70298_a(i, 1);
                break;
            }
            product = stack.func_77946_l();
            product.field_77994_a = 1;
            break;
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return StackUtils.EMPTY_STACK_ARRAY;
    }

    @Override
    public LinkedList<ITrigger> getCustomTriggers() {
        if (!this.hasMaster()) {
            return null;
        }
        LinkedList<ITrigger> list = new LinkedList<ITrigger>();
        list.add(PluginFarming.lowResourceLiquid50);
        list.add(PluginFarming.lowResourceLiquid25);
        list.add(PluginFarming.lowSoil128);
        list.add(PluginFarming.lowSoil64);
        list.add(PluginFarming.lowSoil32);
        list.add(PluginFarming.lowFertilizer50);
        list.add(PluginFarming.lowFertilizer25);
        return list;
    }
}

