/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogicWatered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private final IFarmable[] seeds;

    public FarmLogicCrops(IFarmHousing housing, IFarmable[] seeds) {
        super(housing, new ItemStack[]{new ItemStack(Blocks.field_150346_d)}, new ItemStack[]{new ItemStack(Blocks.field_150458_ak)}, new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack((Block)Blocks.field_150349_c)});
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        ArrayList products = this.produce;
        this.produce = new ArrayList();
        Vect coords = new Vect(this.housing.getCoords());
        Vect area = new Vect(this.housing.getArea());
        Vect offset = new Vect(this.housing.getOffset());
        Vect min = coords.add(offset);
        Vect max = coords.add(offset).add(area);
        AxisAlignedBB harvestBox = AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = this.housing.getWorld().func_72872_a(Entity.class, harvestBox);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack contained;
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityItem)) continue;
            EntityItem item = (EntityItem)entity;
            if (item.field_70128_L || !this.isAcceptedGermling(contained = item.func_92059_d()) && !this.isWindfall(contained)) continue;
            this.produce.add(contained.func_77946_l());
            item.func_70106_y();
        }
        return products;
    }

    @Override
    protected boolean maintainCrops(int x, int y, int z, ForgeDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y, z, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) continue;
            ItemStack below = this.getAsItemStack(position.add(new Vect(0, -1, 0)));
            if (this.ground[0].func_77973_b() != below.func_77973_b() || below.func_77960_j() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(Vect position) {
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, this.world, position.x, position.y, position.z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, y + 1, z, direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(this.world, position.x, position.y, position.z);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

