/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FarmLogicHomogenous
extends FarmLogic {
    protected final ItemStack[] resource;
    protected final ItemStack[] ground;
    protected final ItemStack[] waste;
    protected final IFarmable[] germlings;
    ArrayList<ItemStack> produce = new ArrayList();

    public FarmLogicHomogenous(IFarmHousing housing, ItemStack[] resource, ItemStack[] ground, ItemStack[] waste, IFarmable[] germlings) {
        super(housing);
        this.resource = resource;
        this.ground = ground;
        this.waste = waste;
        this.germlings = germlings;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource[0].func_77969_a(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(int x, int y, int z, ForgeDirection direction, int extent) {
        this.world = this.housing.getWorld();
        if (this.maintainSoil(x, y, z, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(x, y + 1, z, direction, extent);
    }

    private boolean maintainSoil(int x, int yGround, int z, ForgeDirection direction, int extent) {
        if (!this.housing.hasResources(this.resource)) {
            return false;
        }
        block0: for (int i = 0; i < extent; ++i) {
            Vect position = this.translateWithOffset(x, yGround, z, direction, i);
            if (!this.isAirBlock(position) && !Utils.isReplaceableBlock(this.world, position.x, position.y, position.z)) {
                ItemStack block = this.getAsItemStack(position);
                for (ItemStack grnd : this.ground) {
                    if (StackUtils.isIdenticalItem(grnd, block)) continue block0;
                }
                boolean removedWaste = false;
                if (this.waste.length > 0) {
                    for (ItemStack wste : this.waste) {
                        if (!wste.func_77969_a(block)) continue;
                        this.produce.add(wste.func_77946_l());
                        removedWaste = true;
                        break;
                    }
                }
                if (!removedWaste) {
                    return false;
                }
            }
            this.setBlock(position, StackUtils.getBlock(this.ground[0]), this.ground[0].func_77960_j());
            this.housing.removeResources(this.resource);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(int var1, int var2, int var3, ForgeDirection var4, int var5);
}

