/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import forestry.core.utils.Vect;
import forestry.farming.logic.CropBlock;
import forestry.plugins.PluginFarmCraftory;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FarmableFarmCraftory
implements IFarmable {
    Collection<ItemStack> germlings;
    Collection<ItemStack> windfall;

    public FarmableFarmCraftory(Collection<ItemStack> germlings, Collection<ItemStack> windfall) {
        this.germlings = germlings;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        return block == PluginFarmCraftory.blockSingle || block == PluginFarmCraftory.blockMulti;
    }

    @Override
    public ICrop getCropAt(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != PluginFarmCraftory.blockSingle && block != PluginFarmCraftory.blockMulti) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return null;
        }
        if (PluginFarmCraftory.getGrowthStage(tile) < 2) {
            return null;
        }
        return new CropBlock(world, block, world.func_72805_g(x, y, z), new Vect(x, y, z));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        for (ItemStack seed : this.germlings) {
            if (!StackUtils.isIdenticalItem(seed, itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(ItemStack germling, World world, int x, int y, int z) {
        return germling.func_77946_l().func_77943_a(Utils.getForestryPlayer(world, x, y, z), world, x, y - 1, z, 1, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack fruit : this.windfall) {
            if (!StackUtils.isIdenticalItem(fruit, itemstack)) continue;
            return true;
        }
        return false;
    }
}

